/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.camunda;

import dev.dsf.bpe.camunda.FallbackSerializerFactory;
import dev.dsf.bpe.plugin.ProcessPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.value.PrimitiveValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackSerializerFactoryImpl
implements FallbackSerializerFactory {
    private static final Logger logger = LoggerFactory.getLogger(FallbackSerializerFactoryImpl.class);
    private final Map<ClassLoader, List<TypedValueSerializerWrapper>> serializersByClassLoader = new HashMap<ClassLoader, List<TypedValueSerializerWrapper>>();
    private final Map<String, TypedValueSerializerWrapper> serializersByName = new HashMap<String, TypedValueSerializerWrapper>();

    @Override
    public void setProcessPlugins(List<ProcessPlugin<?, ?>> plugins) {
        List serializers = plugins.stream().map(ProcessPlugin::getTypedValueSerializers).flatMap(Collection::stream).map(TypedValueSerializerWrapper::new).collect(Collectors.toList());
        this.serializersByName.putAll(serializers.stream().collect(Collectors.toMap(TypedValueSerializer::getName, Function.identity())));
        this.serializersByClassLoader.putAll(serializers.stream().collect(Collectors.groupingBy(s -> s.getType().getClass().getClassLoader(), Collectors.mapping(Function.identity(), Collectors.toList()))));
    }

    public TypedValueSerializer<?> getSerializer(String serializerName) {
        if (serializerName == null) {
            return null;
        }
        logger.debug("Getting serializer for {}", (Object)serializerName);
        return this.serializersByName.getOrDefault(serializerName, null);
    }

    public TypedValueSerializer<?> getSerializer(TypedValue value) {
        if (value == null) {
            return null;
        }
        ClassLoader classLoader = this.getClassLoader(value);
        if (classLoader != null) {
            logger.debug("Getting serializer for {} from class loader {}", (Object)this.getName(value), (Object)classLoader.getName());
            return this.serializersByClassLoader.getOrDefault(classLoader, Collections.emptyList()).stream().filter(s -> s.canHandle(value)).findFirst().orElse(null);
        }
        return null;
    }

    private ClassLoader getClassLoader(TypedValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PrimitiveValue) {
            return value.getType().getClass().getClassLoader();
        }
        if (value.getValue() != null) {
            return value.getValue().getClass().getClassLoader();
        }
        return null;
    }

    private String getName(TypedValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PrimitiveValue) {
            return ((PrimitiveValue)value).getType().getJavaType().getName();
        }
        if (value.getValue() != null) {
            return value.getClass().getName();
        }
        if (value.getType() != null) {
            return value.getType().getName();
        }
        return "?";
    }

    public static final class TypedValueSerializerWrapper<T extends TypedValue>
    extends AbstractTypedValueSerializer<T> {
        final TypedValueSerializer<T> delegate;

        TypedValueSerializerWrapper(TypedValueSerializer<T> delegate) {
            super(delegate.getType());
            this.delegate = delegate;
        }

        ClassLoader getClassLoader() {
            return this.delegate.getClass().getClassLoader();
        }

        public String getName() {
            return this.getClassLoader().getName() + "/" + this.delegate.getName();
        }

        public void writeValue(T value, ValueFields valueFields) {
            this.delegate.writeValue(value, valueFields);
        }

        public T readValue(ValueFields valueFields, boolean deserializeValue, boolean isTransient) {
            return (T)this.delegate.readValue(valueFields, deserializeValue, isTransient);
        }

        public T convertToTypedValue(UntypedValueImpl untypedValue) {
            return (T)this.delegate.convertToTypedValue(untypedValue);
        }

        public boolean canHandle(TypedValue value) {
            return this.delegate.canHandle(value);
        }

        protected boolean canWriteValue(TypedValue value) {
            throw new UnsupportedOperationException("canWriteValue method not supported");
        }
    }
}

