/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.authentication;

import dev.dsf.bpe.authentication.BpeServerRole;
import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;

public class IdentityProviderImpl
implements IdentityProvider {
    public Identity getIdentity(final DsfOpenIdCredentials credentials) {
        return new PractitionerIdentity(){

            public String getName() {
                return credentials.getUserId();
            }

            public String getDisplayName() {
                return this.getName();
            }

            public boolean isLocalIdentity() {
                return true;
            }

            public boolean hasDsfRole(DsfRole role) {
                return BpeServerRole.ORGANIZATION.equals(role);
            }

            public Set<DsfRole> getDsfRoles() {
                return Collections.singleton(BpeServerRole.ORGANIZATION);
            }

            public Optional<String> getOrganizationIdentifierValue() {
                return Optional.empty();
            }

            public Organization getOrganization() {
                return null;
            }

            public Practitioner getPractitioner() {
                return null;
            }

            public Set<Coding> getPractionerRoles() {
                return Collections.emptySet();
            }

            public Optional<DsfOpenIdCredentials> getCredentials() {
                return Optional.of(credentials);
            }

            public Optional<X509Certificate> getCertificate() {
                return Optional.empty();
            }
        };
    }

    public Identity getIdentity(final X509Certificate[] certificates) {
        return new OrganizationIdentity(){

            public String getName() {
                return certificates[0].getSubjectX500Principal().getName("RFC1779");
            }

            public String getDisplayName() {
                return this.getName();
            }

            public Set<DsfRole> getDsfRoles() {
                return Collections.singleton(BpeServerRole.ORGANIZATION);
            }

            public Organization getOrganization() {
                return null;
            }

            public boolean isLocalIdentity() {
                return true;
            }

            public Optional<String> getOrganizationIdentifierValue() {
                return Optional.empty();
            }

            public boolean hasDsfRole(DsfRole role) {
                return BpeServerRole.ORGANIZATION.equals(role);
            }

            public Optional<X509Certificate> getCertificate() {
                return Optional.of(certificates[0]);
            }
        };
    }
}

