/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.webservice;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

@Path(value="Process")
public class ProcessService
implements InitializingBean {
    public static final String PATH = "Process";
    private static final Logger logger = LoggerFactory.getLogger(ProcessService.class);
    private final RuntimeService runtimeService;
    private final RepositoryService repositoryService;

    public ProcessService(RuntimeService runtimeService, RepositoryService repositoryService) {
        this.runtimeService = runtimeService;
        this.repositoryService = repositoryService;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.runtimeService, "runtimeService");
        Objects.requireNonNull(this.repositoryService, "repositoryService");
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionDomain, String processDefinitionKey, String versionTag) {
        if (versionTag != null && !versionTag.isBlank()) {
            return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionDomain + "_" + processDefinitionKey).versionTag(versionTag).singleResult();
        }
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionDomain + "_" + processDefinitionKey).latestVersion().singleResult();
    }

    @GET
    @Path(value="/{domain}/{key}")
    public Response read(@PathParam(value="domain") String domain, @PathParam(value="key") String key, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        ProcessDefinition processDefinition = this.getProcessDefinition(domain, key, null);
        if (processDefinition == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Deployment deployment = (Deployment)((DeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).orderByDeploymentTime().desc()).singleResult();
        if (deployment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinition.getId());
        return Response.ok((Object)bpmnModelInstance.getDocument().getDomSource()).header("Content-Disposition", (Object)("attachment;filename=" + deployment.getSource())).build();
    }

    @GET
    @Path(value="/{domain}/{key}/{version}")
    public Response vread(@PathParam(value="domain") String domain, @PathParam(value="key") String key, @PathParam(value="version") String version, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        ProcessDefinition processDefinition = this.getProcessDefinition(domain, key, version);
        if (processDefinition == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Deployment deployment = (Deployment)((DeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).orderByDeploymentTime().desc()).singleResult();
        if (deployment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinition.getId());
        return Response.ok((Object)bpmnModelInstance.getDocument().getDomSource()).header("Content-Disposition", (Object)("attachment;filename=" + deployment.getSource())).build();
    }
}

