/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.dsf.bpe.v1.variables.Target;
import dev.dsf.bpe.variables.TargetImpl;
import dev.dsf.bpe.variables.TargetValues;
import java.io.IOException;
import java.util.Objects;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.springframework.beans.factory.InitializingBean;

public class TargetSerializer
extends PrimitiveValueSerializer<TargetValues.TargetValue>
implements InitializingBean {
    private final ObjectMapper objectMapper;

    public TargetSerializer(ObjectMapper objectMapper) {
        super(TargetValues.VALUE_TYPE);
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.objectMapper, "objectMapper");
    }

    public void writeValue(TargetValues.TargetValue value, ValueFields valueFields) {
        Target target = (Target)value.getValue();
        try {
            if (target != null) {
                valueFields.setByteArrayValue(this.objectMapper.writeValueAsBytes((Object)target));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public TargetValues.TargetValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return TargetValues.create((TargetImpl)untypedValue.getValue());
    }

    public TargetValues.TargetValue readValue(ValueFields valueFields, boolean asTransientValue) {
        byte[] bytes = valueFields.getByteArrayValue();
        try {
            TargetImpl target = bytes == null || bytes.length <= 0 ? null : (TargetImpl)this.objectMapper.readValue(bytes, TargetImpl.class);
            return TargetValues.create(target);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

