/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.service.AbstractResourceProvider;
import dev.dsf.bpe.v1.service.EndpointProvider;
import dev.dsf.bpe.v1.service.FhirWebserviceClientProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointProviderImpl
extends AbstractResourceProvider
implements EndpointProvider {
    private static final Logger logger = LoggerFactory.getLogger(EndpointProviderImpl.class);

    public EndpointProviderImpl(FhirWebserviceClientProvider clientProvider, String localEndpointAddress) {
        super(clientProvider, localEndpointAddress);
    }

    public Optional<Endpoint> getLocalEndpoint() {
        Bundle resultBundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(Endpoint.class, Map.of("status", Collections.singletonList("active"), "address", Collections.singletonList(this.localEndpointAddress)));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getEntry().size() != 1 || resultBundle.getEntryFirstRep().getResource() == null || !(resultBundle.getEntryFirstRep().getResource() instanceof Endpoint)) {
            logger.warn("No active (or more than one) Endpoint found with address '{}'", (Object)this.localEndpointAddress);
            return Optional.empty();
        }
        return Optional.of((Endpoint)resultBundle.getEntryFirstRep().getResource());
    }

    public String getLocalEndpointAddress() {
        return this.localEndpointAddress;
    }

    public Optional<Endpoint> getEndpoint(Identifier endpointIdentifier) {
        if (endpointIdentifier == null) {
            logger.debug("Endpoint identifier is null");
            return Optional.empty();
        }
        String endpointIdSp = this.toSearchParameter(endpointIdentifier);
        Bundle resultBundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(Endpoint.class, Map.of("status", Collections.singletonList("active"), "identifier", Collections.singletonList(endpointIdSp)));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getTotal() != 1 || resultBundle.getEntryFirstRep().getResource() == null || !(resultBundle.getEntryFirstRep().getResource() instanceof Endpoint)) {
            logger.warn("No active (or more than one) Endpoint found with identifier '{}'", (Object)endpointIdSp);
            return Optional.empty();
        }
        return Optional.of((Endpoint)resultBundle.getEntryFirstRep().getResource());
    }

    public Optional<Endpoint> getEndpoint(Identifier parentOrganizationIdentifier, Identifier memberOrganizationIdentifier, Coding memberOrganizationRole) {
        if (parentOrganizationIdentifier == null) {
            logger.debug("Parent organiztion identifier is null");
            return Optional.empty();
        }
        if (memberOrganizationIdentifier == null) {
            logger.debug("Member organiztion identifier is null");
            return Optional.empty();
        }
        if (memberOrganizationRole == null) {
            logger.debug("Member organiztion role is null");
            return Optional.empty();
        }
        String parentOrganizationIdSp = this.toSearchParameter(parentOrganizationIdentifier);
        String memberOrganizationIdSp = this.toSearchParameter(memberOrganizationIdentifier);
        String memberOrganizationRoleSp = this.toSearchParameter(memberOrganizationRole);
        Bundle resultBundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(OrganizationAffiliation.class, Map.of("active", Collections.singletonList("true"), "primary-organization:identifier", Collections.singletonList(parentOrganizationIdSp), "participating-organization:identifier", Collections.singletonList(memberOrganizationIdSp), "role", Collections.singletonList(memberOrganizationRoleSp), "_include", Collections.singletonList("OrganizationAffiliation:endpoint")));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getTotal() != 1 || resultBundle.getEntryFirstRep().getResource() == null || !(resultBundle.getEntryFirstRep().getResource() instanceof OrganizationAffiliation)) {
            logger.warn("No active (or more than one) OrganizationAffiliation found with primary-organization identifier '{}', participating-organization identifier '{}' and role '{}'", new Object[]{parentOrganizationIdSp, memberOrganizationIdSp, memberOrganizationRoleSp});
            return Optional.empty();
        }
        if (this.getActiveEndpointFromInclude(resultBundle).count() != 1L) {
            logger.warn("No active Endpoint found for active OrganizationAffiliation with primary-organization identifier '{}', participating-organization identifier '{}' and role '{}'", new Object[]{parentOrganizationIdSp, memberOrganizationIdSp, memberOrganizationRoleSp});
            return Optional.empty();
        }
        return this.getActiveEndpointFromInclude(resultBundle).findFirst();
    }

    private Stream<Endpoint> getActiveEndpointFromInclude(Bundle resultBundle) {
        return resultBundle.getEntry().stream().filter(Bundle.BundleEntryComponent::hasSearch).filter(e -> Bundle.SearchEntryMode.INCLUDE.equals((Object)e.getSearch().getMode())).filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(r -> r instanceof Endpoint).map(r -> (Endpoint)r).filter(e -> Endpoint.EndpointStatus.ACTIVE.equals((Object)e.getStatus()));
    }

    public List<Endpoint> getEndpoints(Identifier parentOrganizationIdentifier, Coding memberOrganizationRole) {
        if (parentOrganizationIdentifier == null) {
            logger.debug("Parent organiztion identifier is null");
            return Collections.emptyList();
        }
        if (memberOrganizationRole == null) {
            logger.debug("Member organiztion role is null");
            return Collections.emptyList();
        }
        String parentOrganizationIdSp = this.toSearchParameter(parentOrganizationIdentifier);
        String memberOrganizationRoleSp = this.toSearchParameter(memberOrganizationRole);
        Map<String, List<String>> parameters = Map.of("active", Collections.singletonList("true"), "primary-organization:identifier", Collections.singletonList(parentOrganizationIdSp), "role", Collections.singletonList(memberOrganizationRoleSp), "_include", Collections.singletonList("OrganizationAffiliation:endpoint"));
        return this.search(OrganizationAffiliation.class, parameters, Bundle.SearchEntryMode.INCLUDE, Endpoint.class, e -> Endpoint.EndpointStatus.ACTIVE.equals((Object)e.getStatus()));
    }
}

