/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.bpe.client.FhirClientProvider;
import dev.dsf.bpe.subscription.EventResourceHandler;
import dev.dsf.bpe.subscription.EventType;
import dev.dsf.bpe.subscription.ExistingResourceLoader;
import dev.dsf.bpe.subscription.FhirConnector;
import dev.dsf.bpe.subscription.PingEventResourceHandler;
import dev.dsf.bpe.subscription.SubscriptionHandlerFactory;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.WebsocketClient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class FhirConnectorImpl<R extends Resource>
implements FhirConnector,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FhirConnectorImpl.class);
    private final String resourcePath;
    private final FhirClientProvider clientProvider;
    private final FhirContext fhirContext;
    private final SubscriptionHandlerFactory<R> subscriptionHandlerFactory;
    private final long retrySleepMillis;
    private final int maxRetries;
    private final Map<String, List<String>> subscriptionSearchParameter;

    public FhirConnectorImpl(String resourcePath, FhirClientProvider clientProvider, SubscriptionHandlerFactory<R> subscriptionHandlerFactory, FhirContext fhirContext, String subscriptionSearchParameter, long retrySleepMillis, int maxRetries) {
        this.resourcePath = resourcePath;
        this.clientProvider = clientProvider;
        this.subscriptionHandlerFactory = subscriptionHandlerFactory;
        this.fhirContext = fhirContext;
        this.subscriptionSearchParameter = FhirConnectorImpl.parse(subscriptionSearchParameter, null);
        this.retrySleepMillis = retrySleepMillis;
        this.maxRetries = maxRetries;
    }

    private static Map<String, List<String>> parse(String queryParameters, String expectedPath) {
        if (expectedPath != null && !expectedPath.isBlank()) {
            UriComponents components = UriComponentsBuilder.fromUriString((String)queryParameters).build();
            if (!expectedPath.equals(components.getPath())) {
                throw new RuntimeException("Unexpected query parameters format '" + queryParameters + "'");
            }
            return components.getQueryParams();
        }
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)(queryParameters.startsWith("?") ? queryParameters : "?" + queryParameters)).build();
        return componentes.getQueryParams();
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.clientProvider, "clientProvider");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
    }

    @Override
    public void connect() {
        logger.debug("Retrieving Subscription and connecting to websocket");
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(this::retrieveWebsocketSubscription, Executors.newSingleThreadExecutor()).thenApply(this::loadExistingResources)).thenAccept(this::connectWebsocket)).exceptionally(this::onError);
    }

    private Subscription retrieveWebsocketSubscription() {
        if (this.maxRetries >= 0) {
            return this.retry(this::doRetrieveWebsocketSubscription);
        }
        return this.retryForever(this::doRetrieveWebsocketSubscription);
    }

    private Subscription retry(Supplier<Subscription> supplier) {
        Throwable lastException = null;
        for (int retryCounter = 0; retryCounter <= this.maxRetries; ++retryCounter) {
            try {
                return supplier.get();
            }
            catch (RuntimeException e) {
                if (retryCounter < this.maxRetries) {
                    logger.warn("Error while retrieving websocket subscription ({}), trying again in {} ms (retry {} of {})", new Object[]{e.getMessage(), this.retrySleepMillis, retryCounter + 1, this.maxRetries});
                    try {
                        Thread.sleep(this.retrySleepMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                lastException = e;
                continue;
            }
        }
        logger.error("Error while retrieving websocket subscription ({}), giving up", (Object)lastException.getMessage());
        throw lastException;
    }

    private Subscription retryForever(Supplier<Subscription> supplier) {
        int retryCounter = 1;
        while (true) {
            try {
                return supplier.get();
            }
            catch (RuntimeException e) {
                logger.warn("Error while retrieving websocket subscription ({}), trying again in {} ms (retry {})", new Object[]{e.getMessage(), this.retrySleepMillis, retryCounter});
                try {
                    Thread.sleep(this.retrySleepMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retryCounter;
                continue;
            }
            break;
        }
    }

    private Subscription doRetrieveWebsocketSubscription() {
        logger.debug("Retrieving websocket subscription");
        Bundle bundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(Subscription.class, this.subscriptionSearchParameter);
        if (!Bundle.BundleType.SEARCHSET.equals((Object)bundle.getType())) {
            throw new RuntimeException("Could not retrieve searchset for subscription search query " + this.subscriptionSearchParameter + ", but got " + bundle.getType());
        }
        if (bundle.getTotal() != 1) {
            throw new RuntimeException("Could not retrieve exactly one result for subscription search query " + this.subscriptionSearchParameter);
        }
        if (!(bundle.getEntryFirstRep().getResource() instanceof Subscription)) {
            throw new RuntimeException("Could not retrieve exactly one Subscription for subscription search query " + this.subscriptionSearchParameter + ", but got " + bundle.getEntryFirstRep().getResource().getResourceType());
        }
        Subscription subscription = (Subscription)bundle.getEntryFirstRep().getResource();
        logger.debug("Subscription with id {} found", (Object)subscription.getIdElement().getIdPart());
        return subscription;
    }

    private Subscription loadExistingResources(Subscription subscription) {
        logger.debug("Downloading existing resources");
        FhirWebserviceClient client = this.clientProvider.getLocalWebserviceClient();
        ExistingResourceLoader<R> existingResourceLoader = this.subscriptionHandlerFactory.createExistingResourceLoader(client);
        Map<String, List<String>> subscriptionCriteria = FhirConnectorImpl.parse(subscription.getCriteria(), this.resourcePath);
        existingResourceLoader.readExistingResources(subscriptionCriteria);
        return subscription;
    }

    private void connectWebsocket(Subscription subscription) {
        logger.debug("Connecting to websocket");
        WebsocketClient client = this.clientProvider.getLocalWebsocketClient(() -> this.connect(), subscription.getIdElement().getIdPart());
        EventType eventType = this.toEventType(subscription.getChannel().getPayload());
        if (EventType.PING.equals((Object)eventType)) {
            Map<String, List<String>> subscriptionCriteria = FhirConnectorImpl.parse(subscription.getCriteria(), this.resourcePath);
            this.setPingEventHandler(client, subscription.getIdElement().getIdPart(), subscriptionCriteria);
        } else {
            this.setResourceEventHandler(client, eventType);
        }
        try {
            logger.info("Connecting websocket to local FHIR server with subscription id {}", (Object)subscription.getIdElement().getIdPart());
            client.connect();
        }
        catch (Exception e) {
            logger.warn("Error while connecting websocket to local FHIR server", (Throwable)e);
            throw e;
        }
    }

    private Void onError(Throwable t) {
        logger.error("Error while connecting to websocket", t);
        return null;
    }

    private EventType toEventType(String payload) {
        if (payload == null) {
            return EventType.PING;
        }
        switch (payload) {
            case "application/json+fhir": 
            case "application/fhir+json": {
                return EventType.JSON;
            }
            case "application/xml+fhir": 
            case "application/fhir+xml": {
                return EventType.XML;
            }
        }
        throw new RuntimeException("Unsupportet subscription.payload " + payload);
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onContextClosedEvent(ContextClosedEvent event) {
        this.clientProvider.disconnectAll();
    }

    private void setPingEventHandler(WebsocketClient client, String subscriptionIdPart, Map<String, List<String>> searchCriteriaQueryParameters) {
        FhirWebserviceClient webserviceClient = this.clientProvider.getLocalWebserviceClient();
        ExistingResourceLoader<R> existingResourceLoader = this.subscriptionHandlerFactory.createExistingResourceLoader(webserviceClient);
        PingEventResourceHandler pingHandler = this.subscriptionHandlerFactory.createPingEventResourceHandler(existingResourceLoader);
        client.setPingHandler(ping -> pingHandler.onPing((String)ping, subscriptionIdPart, searchCriteriaQueryParameters));
    }

    private void setResourceEventHandler(WebsocketClient client, EventType eventType) {
        EventResourceHandler<R> eventHandler = this.subscriptionHandlerFactory.createEventResourceHandler();
        client.setDomainResourceHandler(eventHandler::onResource, this.createParserFactory(eventType, this.fhirContext));
    }

    private Supplier<IParser> createParserFactory(EventType eventType, FhirContext fhirContext) {
        switch (eventType) {
            case XML: {
                return () -> this.configureParser(fhirContext.newXmlParser());
            }
            case JSON: {
                return () -> this.configureParser(fhirContext.newJsonParser());
            }
        }
        throw new RuntimeException("EventType " + eventType + " not supported");
    }

    private IParser configureParser(IParser p) {
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        return p;
    }
}

