/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import dev.dsf.common.config.ProxyConfig;
import dev.dsf.common.config.ProxyConfigImpl;
import dev.dsf.common.documentation.Documentation;
import dev.dsf.tools.docker.secrets.DockerSecretsPropertySourceFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@PropertySource(value={"file:conf/config.properties"}, encoding="UTF-8", ignoreResourceNotFound=true)
public class PropertiesConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesConfig.class);
    @Documentation(required=true, description="The address of the database used for the DSF BPE server", recommendation="Change only if you don't use the provided docker-compose from the installation guide or made changes to the database settings/networking in the docker-compose", example="jdbc:postgresql://db/bpe")
    @Value(value="${dev.dsf.bpe.db.url}")
    private String dbUrl;
    @Documentation(description="The user name to access the database from the DSF BPE server")
    @Value(value="${dev.dsf.bpe.db.user.username:bpe_server_user}")
    private String dbUsername;
    @Documentation(required=true, description="The password to access the database from the DSF BPE server", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/db_user.password")
    @Value(value="${dev.dsf.bpe.db.user.password}")
    private char[] dbPassword;
    @Documentation(description="The user name to access the database from the DSF BPE server for camunda processes", recommendation="Use a different user then in *DEV_DSF_BPE_DB_USER_USERNAME*")
    @Value(value="${dev.dsf.bpe.db.user.camunda.username:camunda_server_user}")
    private String dbCamundaUsername;
    @Documentation(required=true, description="The password to access the database from the DSF BPE server for camunda processes", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/db_user_camunda.password")
    @Value(value="${dev.dsf.bpe.db.user.camunda.password}")
    private char[] dbCamundaPassword;
    @Documentation(required=true, description="The local identifier value used in the Allow-List", recommendation="By convention: The shortest possible FQDN that resolve the homepage of the organization", example="hospital.com")
    @Value(value="${dev.dsf.bpe.fhir.server.organization.identifier.value}")
    private String organizationIdentifierValue;
    @Documentation(required=true, description="PEM encoded file with one or more trusted root certificates to validate server certificates for https connections to local and remote DSF FHIR servers", recommendation="Use docker secret file to configure", example="/run/secrets/app_server_trust_certificates.pem")
    @Value(value="${dev.dsf.bpe.fhir.client.trust.server.certificate.cas}")
    private String clientCertificateTrustStoreFile;
    @Documentation(required=true, description="PEM encoded file with local client certificate for https connections to local and remote DSF FHIR servers", recommendation="Use docker secret file to configure", example="/run/secrets/app_client_certificate.pem")
    @Value(value="${dev.dsf.bpe.fhir.client.certificate}")
    private String clientCertificateFile;
    @Documentation(required=true, description="Private key corresponding to the local client certificate as PEM encoded file. Use ${env_variable}_PASSWORD* or *${env_variable}_PASSWORD_FILE* if private key is encrypted", recommendation="Use docker secret file to configure", example="/run/secrets/app_client_certificate_private_key.pem")
    @Value(value="${dev.dsf.bpe.fhir.client.certificate.private.key}")
    private String clientCertificatePrivateKeyFile;
    @Documentation(description="Password to decrypt the local client certificate encrypted private key", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/app_client_certificate_private_key.pem.password")
    @Value(value="${dev.dsf.bpe.fhir.client.certificate.private.key.password:#{null}}")
    private char[] clientCertificatePrivateKeyFilePassword;
    @Documentation(description="The timeout in milliseconds until a reading a resource from a remote DSF FHIR server is aborted", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.bpe.fhir.client.remote.timeout.read:60000}")
    private int webserviceClientRemoteReadTimeout;
    @Documentation(description="The timeout in milliseconds until a connection is established with a remote DSF FHIR server", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.bpe.fhir.client.remote.timeout.connect:5000}")
    private int webserviceClientRemoteConnectTimeout;
    @Documentation(description="To enable verbose logging of requests to and replies from remote DSF FHIR servers, set to `true`")
    @Value(value="${dev.dsf.bpe.fhir.client.remote.verbose:false}")
    private boolean webserviceClientRemoteVerbose;
    @Documentation(required=true, description="The base address of the local DSF FHIR server to read/store fhir resources", example="https://foo.bar/fhir")
    @Value(value="${dev.dsf.bpe.fhir.server.base.url}")
    private String serverBaseUrl;
    @Documentation(description="The timeout in milliseconds until reading a resource from the local DSF FHIR server is aborted", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.bpe.fhir.client.local.timeout.read:60000}")
    private int webserviceClientLocalReadTimeout;
    @Documentation(description="The timeout in milliseconds until a connection is established with the local DSF FHIR server", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.bpe.fhir.client.local.timeout.connect:2000}")
    private int webserviceClientLocalConnectTimeout;
    @Documentation(description="To enable verbose logging of requests to and replies from the local DSF FHIR server, set to `true`")
    @Value(value="${dev.dsf.bpe.fhir.client.local.verbose:false}")
    private boolean webserviceClientLocalVerbose;
    @Documentation(description="Subscription to receive notifications about task resources from the DSF FHIR server")
    @Value(value="${dev.dsf.bpe.fhir.task.subscription.search.parameter:?criteria=Task%3Fstatus%3Drequested&status=active&type=websocket&payload=application/fhir%2Bjson}")
    private String taskSubscriptionSearchParameter;
    @Documentation(description="Subscription to receive notifications about questionnaire response resources from the DSF FHIR server")
    @Value(value="${dev.dsf.bpe.fhir.questionnaire.response.subscription.search.parameter:?criteria=QuestionnaireResponse%3Fstatus%3Dcompleted&status=active&type=websocket&payload=application/fhir%2Bjson}")
    private String questionnaireResponseSubscriptionSearchParameter;
    @Documentation(description="Number of retries until a websocket connection can be established with the DSF FHIR server, `-1` means infinite number of retries")
    @Value(value="${dev.dsf.bpe.fhir.task.subscription.retry.max:-1}")
    private int websocketMaxRetries;
    @Documentation(description="Milliseconds between two retries to establish a websocket connection with the DSF FHIR server")
    @Value(value="${dev.dsf.bpe.fhir.task.subscription.retry.sleep:5000}")
    private long websocketRetrySleepMillis;
    @Documentation(description="Directory containing the DSF BPE process plugins for deployment on startup of the DSF BPE server", recommendation="Change only if you don't use the provided directory structure from the installation guide or made changes to tit")
    @Value(value="${dev.dsf.bpe.process.plugin.directroy:process}")
    private String processPluginDirectory;
    @Documentation(description="List of process names that should be excluded from deployment during startup of the DSF BPE server; comma or space separated list, YAML block scalars supported", recommendation="Only deploy processes that can be started depending on your organization's roles in the Allow-List")
    @Value(value="#{'${dev.dsf.bpe.process.excluded:}'.trim().split('(,[ ]?)|(\\n)')}")
    private List<String> processExcluded;
    @Documentation(description="List of already deployed process names that should be retired during startup of the DSF BPE server; comma or space separated list, YAML block scalars supported", recommendation="Retire processes that where deployed previously but are not anymore available")
    @Value(value="#{'${dev.dsf.bpe.process.retired:}'.trim().split('(,[ ]?)|(\\n)')}")
    private List<String> processRetired;
    @Documentation(description="Number of retries until a connection can be established with the local DSF FHIR server during process deployment, `-1` means infinite number of retries")
    @Value(value="${dev.dsf.bpe.process.fhir.server.retry.max:-1}")
    private int fhirServerRequestMaxRetries;
    @Documentation(description="Milliseconds between two retries to establish a connection with the local DSF FHIR server during process deployment")
    @Value(value="${dev.dsf.bpe.process.fhir.server.retry.sleep:5000}")
    private long fhirServerRetryDelayMillis;
    @Documentation(description="Mail service sender address", example="sender@localhost")
    @Value(value="${dev.dsf.bpe.mail.fromAddress:}")
    private String mailFromAddress;
    @Documentation(description="Mail service recipient addresses, configure at least one; comma or space separated list, YAML block scalars supported", example="recipient@localhost")
    @Value(value="#{'${dev.dsf.bpe.mail.toAddresses:}'.trim().split('(,[ ]?)|(\\n)')}")
    private List<String> mailToAddresses;
    @Documentation(description="Mail service CC recipient addresses; comma or space separated list, YAML block scalars supported", example="cc.recipient@localhost")
    @Value(value="#{'${dev.dsf.bpe.mail.toAddressesCc:}'.trim().split('(,[ ]?)|(\\n)')}")
    private List<String> mailToAddressesCc;
    @Documentation(description="Mail service reply to addresses; comma or space separated list, YAML block scalars supported", example="reply.to@localhost")
    @Value(value="#{'${dev.dsf.bpe.mail.replyToAddresses:}'.trim().split('(,[ ]?)|(\\n)')}")
    private List<String> mailReplyToAddresses;
    @Documentation(description="To enable SMTP over TLS (smtps), set to `true`")
    @Value(value="${dev.dsf.bpe.mail.useSmtps:false}")
    private boolean mailUseSmtps;
    @Documentation(description="SMTP server hostname", example="smtp.server.de")
    @Value(value="${dev.dsf.bpe.mail.host:#{null}}")
    private String mailServerHostname;
    @Documentation(description="SMTP server port", example="465")
    @Value(value="${dev.dsf.bpe.mail.port:0}")
    private int mailServerPort;
    @Documentation(description="SMTP server authentication username", recommendation="Configure if the SMTP server reqiures username/password authentication; enable SMTP over TLS via *DEV_DSF_BPE_MAIL_USESMTPS*")
    @Value(value="${dev.dsf.bpe.mail.username:#{null}}")
    private String mailServerUsername;
    @Documentation(description="SMTP server authentication password", recommendation="Configure if the SMTP server reqiures username/password authentication; use docker secret file to configure using *${env_variable}_FILE*; enable SMTP over TLS via *DEV_DSF_BPE_MAIL_USESMTPS*")
    @Value(value="${dev.dsf.bpe.mail.password:#{null}}")
    private char[] mailServerPassword;
    @Documentation(description="PEM encoded file with one or more trusted root certificates to validate the server certificate of the SMTP server. Requires SMTP over TLS to be enabled via *DEV_DSF_BPE_MAIL_USESMTPS*", recommendation="Use docker secret file to configure", example="/run/secrets/smtp_server_trust_certificates.pem")
    @Value(value="${dev.dsf.bpe.mail.trust.server.certificate.cas:#{null}}")
    private String mailServerTrustStoreFile;
    @Documentation(description="PEM encoded file with client certificate used to authenticate against the SMTP server. Requires SMTP over TLS to be enabled via *DEV_DSF_BPE_MAIL_USESMTPS*", recommendation="Use docker secret file to configure", example="/run/secrets/smtp_server_client_certificate.pem")
    @Value(value="${dev.dsf.bpe.mail.client.certificate:#{null}}")
    private String mailServerClientCertificateFile;
    @Documentation(description="Private key corresponging to the SMTP server client certificate as PEM encoded file. Use ${env_variable}_PASSWORD* or *${env_variable}_PASSWORD_FILE* if private key is encrypted. Requires SMTP over TLS to be enabled via *DEV_DSF_BPE_MAIL_USESMTPS*", recommendation="Use docker secret file to configure", example="/run/secrets/smtp_server_client_certificate_private_key.pem")
    @Value(value="${dev.dsf.bpe.mail.client.certificate.private.key:#{null}}")
    private String mailServerClientCertificatePrivateKeyFile;
    @Documentation(description="Password to decrypt the local client certificate encrypted private key", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/smtp_server_client_certificate_private_key.pem.password")
    @Value(value="${dev.dsf.bpe.mail.client.certificate.private.key.password:#{null}}")
    private char[] mailServerClientCertificatePrivateKeyFilePassword;
    @Documentation(description="PKCS12 encoded file with S/MIME certificate, private key and certificate chain to enable send mails to be S/MIME signed", recommendation="Use docker secret file to configure", example="/run/secrets/smime_certificate.p12")
    @Value(value="${dev.dsf.bpe.mail.smime.p12Keystore:#{null}}")
    private String mailSmimeSigingKeyStoreFile;
    @Documentation(description="Password to decrypt the PKCS12 encoded S/MIMIE certificate file", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/smime_certificate.p12.password")
    @Value(value="${dev.dsf.bpe.mail.smime.p12Keystore.password:#{null}}")
    private char[] mailSmimeSigingKeyStorePassword;
    @Documentation(description="To enable a test mail being send on startup of the BPE, set to `true`. Requires SMTP server to be configured.")
    @Value(value="${dev.dsf.bpe.mail.sendTestMailOnStartup:false}")
    private boolean sendTestMailOnStartup;
    @Documentation(description="To enable mails being send for every ERROR logged, set to `true`. Requires SMTP server to be configured.")
    @Value(value="${dev.dsf.bpe.mail.sendMailOnErrorLogEvent:false}")
    private boolean sendMailOnErrorLogEvent;
    @Documentation(description="Number of previous INFO, WARN log messages to include in ERROR log event mails (>=0). Requires send mail on ERROR log event option to be enabled to have an effect.")
    @Value(value="${dev.dsf.bpe.mail.mailOnErrorLogEventBufferSize:4}")
    private int mailOnErrorLogEventBufferSize;
    @Documentation(description="Location of the BPE debug log as displayed in the footer of ERROR log event mails, does not modify the actual location of the debug log file. Requires send mail on ERROR log event option to be enabled to have an effect.")
    @Value(value="${dev.dsf.bpe.mail.mailOnErrorLogEventDebugLogLocation:/opt/bpe/log/bpe.log}")
    private String mailOnErrorLogEventDebugLogLocation;
    @Documentation(description="To enable debug log messages for every bpmn activity start, set to `true`.", recommendation="This debug function should only be activated during process plugin development.")
    @Value(value="${dev.dsf.bpe.debug.log.message.onActivityStart:false}")
    private boolean debugLogMessageOnActivityStart;
    @Documentation(description="To enable debug log messages for every bpmn activity end, set to `true`.", recommendation="This debug function should only be activated during process plugin development.")
    @Value(value="${dev.dsf.bpe.debug.log.message.onActivityEnd:false}")
    private boolean debugLogMessageOnActivityEnd;
    @Documentation(description="To enable loging bpmn variables for every bpmn activity start or end, when logging of these events is enabled, set to `true`.", recommendation="This debug function should only be activated during process plugin development. WARNNING: Confidential information may be leaked via the debug log!")
    @Value(value="${dev.dsf.bpe.debug.log.message.variables:false}")
    private boolean debugLogMessageVariables;
    @Value(value="${dev.dsf.server.status.port}")
    private int jettyStatusConnectorPort;
    @Documentation(description="Forward (http/https) proxy url, use *DEV_DSF_BPE_PROXY_NOPROXY* to list domains that do not require a forward proxy", example="http://proxy.foo:8080")
    @Value(value="${dev.dsf.proxy.url:#{null}}")
    private String proxyUrl;
    @Documentation(description="Forward proxy username", recommendation="Configure username if proxy requires authentication")
    @Value(value="${dev.dsf.proxy.username:#{null}}")
    private String proxyUsername;
    @Documentation(description="Forward Proxy password", recommendation="Configure password if proxy requires authentication, use docker secret file to configure using *${env_variable}_FILE*")
    @Value(value="${dev.dsf.proxy.password:#{null}}")
    private char[] proxyPassword;
    @Documentation(description="Forward proxy no-proxy list, entries will match exactly or agianst (one level) sub-domains, if no port is specified - all ports are matched; comma or space separated list, YAML block scalars supported", example="foo.bar, test.com:8080")
    @Value(value="#{'${dev.dsf.proxy.noProxy:}'.trim().split('(,[ ]?)|(\\\\n)')}")
    private List<String> proxyNoProxy;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment environment) {
        new DockerSecretsPropertySourceFactory(environment).readDockerSecretsAndAddPropertiesToEnvironment();
        return new PropertySourcesPlaceholderConfigurer();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serverBaseUrl.endsWith("//")) {
            logger.warn("Invalid DSF FHIR server base URL: '{}', URL may not end in '//'", (Object)this.serverBaseUrl);
            throw new IllegalArgumentException("Invalid ServerBaseUrl, ending in //");
        }
        if (!this.serverBaseUrl.startsWith("https://")) {
            logger.warn("Invalid DSF FHIR server base URL: '{}', URL must start with 'https://'", (Object)this.serverBaseUrl);
            throw new IllegalArgumentException("Invalid ServerBaseUrl, not starting with https://");
        }
        if (this.serverBaseUrl.endsWith("/")) {
            logger.warn("DSF FHIR server base URL: '{}', should not end in '/', removing trailing '/'", (Object)this.serverBaseUrl);
        }
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public char[] getDbPassword() {
        return this.dbPassword;
    }

    public String getDbCamundaUsername() {
        return this.dbCamundaUsername;
    }

    public char[] getDbCamundaPassword() {
        return this.dbCamundaPassword;
    }

    public String getOrganizationIdentifierValue() {
        return this.organizationIdentifierValue;
    }

    public String getClientCertificateTrustStoreFile() {
        return this.clientCertificateTrustStoreFile;
    }

    public String getClientCertificateFile() {
        return this.clientCertificateFile;
    }

    public String getClientCertificatePrivateKeyFile() {
        return this.clientCertificatePrivateKeyFile;
    }

    public char[] getClientCertificatePrivateKeyFilePassword() {
        return this.clientCertificatePrivateKeyFilePassword;
    }

    public int getWebserviceClientRemoteReadTimeout() {
        return this.webserviceClientRemoteReadTimeout;
    }

    public int getWebserviceClientRemoteConnectTimeout() {
        return this.webserviceClientRemoteConnectTimeout;
    }

    public boolean getWebserviceClientRemoteVerbose() {
        return this.webserviceClientRemoteVerbose;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl != null && this.serverBaseUrl.endsWith("/") ? this.serverBaseUrl.substring(0, this.serverBaseUrl.length() - 1) : this.serverBaseUrl;
    }

    public int getWebserviceClientLocalReadTimeout() {
        return this.webserviceClientLocalReadTimeout;
    }

    public int getWebserviceClientLocalConnectTimeout() {
        return this.webserviceClientLocalConnectTimeout;
    }

    public boolean getWebserviceClientLocalVerbose() {
        return this.webserviceClientLocalVerbose;
    }

    public String getTaskSubscriptionSearchParameter() {
        return this.taskSubscriptionSearchParameter;
    }

    public String getQuestionnaireResponseSubscriptionSearchParameter() {
        return this.questionnaireResponseSubscriptionSearchParameter;
    }

    public long getWebsocketRetrySleepMillis() {
        return this.websocketRetrySleepMillis;
    }

    public int getWebsocketMaxRetries() {
        return this.websocketMaxRetries;
    }

    public Path getProcessPluginDirectory() {
        return Paths.get(this.processPluginDirectory, new String[0]);
    }

    public List<String> getProcessExcluded() {
        return Collections.unmodifiableList(this.processExcluded);
    }

    public List<String> getProcessRetired() {
        return Collections.unmodifiableList(this.processRetired);
    }

    public int getFhirServerRequestMaxRetries() {
        return this.fhirServerRequestMaxRetries;
    }

    public long getFhirServerRetryDelayMillis() {
        return this.fhirServerRetryDelayMillis;
    }

    public String getMailFromAddress() {
        return this.mailFromAddress;
    }

    public List<String> getMailToAddresses() {
        return this.mailToAddresses;
    }

    public List<String> getMailToAddressesCc() {
        return this.mailToAddressesCc;
    }

    public List<String> getMailReplyToAddresses() {
        return this.mailReplyToAddresses;
    }

    public boolean getMailUseSmtps() {
        return this.mailUseSmtps;
    }

    public String getMailServerHostname() {
        return this.mailServerHostname;
    }

    public int getMailServerPort() {
        return this.mailServerPort;
    }

    public String getMailServerUsername() {
        return this.mailServerUsername;
    }

    public char[] getMailServerPassword() {
        return this.mailServerPassword;
    }

    public String getMailServerTrustStoreFile() {
        return this.mailServerTrustStoreFile;
    }

    public String getMailServerClientCertificateFile() {
        return this.mailServerClientCertificateFile;
    }

    public String getMailServerClientCertificatePrivateKeyFile() {
        return this.mailServerClientCertificatePrivateKeyFile;
    }

    public char[] getMailServerClientCertificatePrivateKeyFilePassword() {
        return this.mailServerClientCertificatePrivateKeyFilePassword;
    }

    public String getMailSmimeSigingKeyStoreFile() {
        return this.mailSmimeSigingKeyStoreFile;
    }

    public char[] getMailSmimeSigingKeyStorePassword() {
        return this.mailSmimeSigingKeyStorePassword;
    }

    public boolean getSendTestMailOnStartup() {
        return this.sendTestMailOnStartup;
    }

    public boolean getSendMailOnErrorLogEvent() {
        return this.sendMailOnErrorLogEvent;
    }

    public int getMailOnErrorLogEventBufferSize() {
        return this.mailOnErrorLogEventBufferSize;
    }

    public String getMailOnErrorLogEventDebugLogLocation() {
        return this.mailOnErrorLogEventDebugLogLocation;
    }

    public boolean getDebugLogMessageOnActivityStart() {
        return this.debugLogMessageOnActivityStart;
    }

    public boolean getDebugLogMessageOnActivityEnd() {
        return this.debugLogMessageOnActivityEnd;
    }

    public boolean getDebugLogMessageVariables() {
        return this.debugLogMessageVariables;
    }

    public int getJettyStatusConnectorPort() {
        return this.jettyStatusConnectorPort;
    }

    @Bean
    public ProxyConfig proxyConfig() {
        return new ProxyConfigImpl(this.proxyUrl, this.proxyUsername, this.proxyPassword, this.proxyNoProxy);
    }
}

