/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import de.rwh.utils.crypto.CertificateHelper;
import de.rwh.utils.crypto.io.CertificateReader;
import de.rwh.utils.crypto.io.PemIo;
import dev.dsf.bpe.mail.LoggingMailService;
import dev.dsf.bpe.mail.SmtpMailService;
import dev.dsf.bpe.spring.config.BuildInfoReaderConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.bpe.v1.service.MailService;
import dev.dsf.tools.build.BuildInfoReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@Configuration
public class MailConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MailConfig.class);
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    BuildInfoReaderConfig buildInfoReaderConfig;

    @Bean
    public MailService mailService() {
        if (this.isConfigured()) {
            try {
                return this.newSmptMailService();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | PKCSException e) {
                throw new RuntimeException(e);
            }
        }
        return new LoggingMailService();
    }

    private boolean isConfigured() {
        return this.propertiesConfig.getMailServerHostname() != null && this.propertiesConfig.getMailServerPort() > 0;
    }

    private MailService newSmptMailService() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, PKCSException {
        String fromAddress = this.propertiesConfig.getMailFromAddress();
        List<String> toAddresses = this.propertiesConfig.getMailToAddresses();
        List<String> toAddressesCc = this.propertiesConfig.getMailToAddressesCc();
        List<String> replyToAddresses = this.propertiesConfig.getMailReplyToAddresses();
        boolean useSmtps = this.propertiesConfig.getMailUseSmtps();
        String mailServerHostname = this.propertiesConfig.getMailServerHostname();
        int mailServerPort = this.propertiesConfig.getMailServerPort();
        String mailServerUsername = this.propertiesConfig.getMailServerUsername();
        char[] mailServerPassword = this.propertiesConfig.getMailServerPassword();
        KeyStore trustStore = this.toTrustStore(this.propertiesConfig.getMailServerTrustStoreFile());
        char[] keyStorePassword = UUID.randomUUID().toString().toCharArray();
        KeyStore keyStore = this.toKeyStore(this.propertiesConfig.getMailServerClientCertificateFile(), this.propertiesConfig.getMailServerClientCertificatePrivateKeyFile(), this.propertiesConfig.getMailServerClientCertificatePrivateKeyFilePassword(), keyStorePassword);
        KeyStore signStore = this.toSmimeSigningStore(this.propertiesConfig.getMailSmimeSigingKeyStoreFile(), this.propertiesConfig.getMailSmimeSigingKeyStorePassword());
        return new SmtpMailService(fromAddress, toAddresses, toAddressesCc, replyToAddresses, useSmtps, mailServerHostname, mailServerPort, mailServerUsername, mailServerPassword, trustStore, keyStore, keyStorePassword, signStore, this.propertiesConfig.getMailSmimeSigingKeyStorePassword(), this.propertiesConfig.getSendMailOnErrorLogEvent(), this.propertiesConfig.getMailOnErrorLogEventBufferSize(), this.propertiesConfig.getMailOnErrorLogEventDebugLogLocation());
    }

    private KeyStore toTrustStore(String trustStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        if (trustStoreFile == null) {
            return null;
        }
        Path trustStorePath = Paths.get(trustStoreFile, new String[0]);
        if (!Files.isReadable(trustStorePath)) {
            throw new IOException("Mail server trust store file '" + trustStorePath.toString() + "' not readable");
        }
        return CertificateReader.allFromCer((Path)trustStorePath);
    }

    private KeyStore toKeyStore(String certificateFile, String privateKeyFile, char[] privateKeyPassword, char[] keyStorePassword) throws IOException, CertificateException, PKCSException, KeyStoreException, NoSuchAlgorithmException {
        if (certificateFile == null && privateKeyFile == null) {
            return null;
        }
        Path certificatePath = Paths.get(certificateFile, new String[0]);
        Path privateKeyPath = Paths.get(privateKeyFile, new String[0]);
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Mail server client certificate file '" + certificatePath.toString() + "' not readable");
        }
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Mail server client certificate private key file '" + privateKeyPath.toString() + "' not readable");
        }
        X509Certificate certificate = PemIo.readX509CertificateFromPem((Path)certificatePath);
        PrivateKey privateKey = PemIo.readPrivateKeyFromPem((BouncyCastleProvider)provider, (Path)privateKeyPath, (char[])privateKeyPassword);
        String subjectCommonName = CertificateHelper.getSubjectCommonName((X509Certificate)certificate);
        return CertificateHelper.toJksKeyStore((PrivateKey)privateKey, (Certificate[])new Certificate[]{certificate}, (String)subjectCommonName, (char[])keyStorePassword);
    }

    private KeyStore toSmimeSigningStore(String mailSmimeSigingKeyStoreFile, char[] mailSmimeSigingKeyStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (mailSmimeSigingKeyStoreFile == null) {
            return null;
        }
        Path keyStorePath = Paths.get(mailSmimeSigingKeyStoreFile, new String[0]);
        if (!Files.isReadable(keyStorePath)) {
            throw new IOException("S/MIME mail signing certificate file '" + keyStorePath.toString() + "' not readable");
        }
        return CertificateReader.fromPkcs12((Path)keyStorePath, (char[])mailSmimeSigingKeyStorePassword);
    }

    public void afterPropertiesSet() throws Exception {
        SmtpMailService.Log4jAppender appender;
        if (this.isConfigured()) {
            logger.info("Mail client config: {fromAddress: {}, toAddresses: {}, toAddressesCc: {}, replyToAddresses: {}, useSmtps: {}, mailServerHostname: {}, mailServerPort: {}, mailServerUsername: {}, mailServerPassword: {}, trustStore: {}, clientCertificate: {}, clientCertificatePrivateKey: {}, clientCertificatePrivateKeyPassword: {}, smimeSigingKeyStore: {}, smimeSigingKeyStorePassword: {}, sendTestMailOnStartup: {}, sendMailOnErrorLogEvent: {}, mailOnErrorLogEventBufferSize: {}, mailOnErrorLogEventDebugLogLocation: {}}", new Object[]{this.propertiesConfig.getMailFromAddress(), this.propertiesConfig.getMailToAddresses(), this.propertiesConfig.getMailToAddressesCc(), this.propertiesConfig.getMailReplyToAddresses(), this.propertiesConfig.getMailUseSmtps(), this.propertiesConfig.getMailServerHostname(), this.propertiesConfig.getMailServerPort(), this.propertiesConfig.getMailServerUsername(), this.propertiesConfig.getMailServerPassword() != null ? "***" : "null", this.propertiesConfig.getMailServerTrustStoreFile(), this.propertiesConfig.getMailServerClientCertificateFile(), this.propertiesConfig.getMailServerClientCertificatePrivateKeyFile(), this.propertiesConfig.getMailServerClientCertificatePrivateKeyFilePassword() != null ? "***" : "null", this.propertiesConfig.getMailSmimeSigingKeyStoreFile(), this.propertiesConfig.getMailSmimeSigingKeyStorePassword() != null ? "***" : "null", this.propertiesConfig.getSendTestMailOnStartup(), this.propertiesConfig.getSendMailOnErrorLogEvent(), this.propertiesConfig.getMailOnErrorLogEventBufferSize(), this.propertiesConfig.getMailOnErrorLogEventDebugLogLocation()});
        } else {
            logger.info("Mail client config: SMTP client not configured, sending mails to debug log, configure at least SMTP server host and port");
        }
        if (this.isConfigured() && (appender = ((SmtpMailService)this.mailService()).getLog4jAppender()) != null) {
            appender.start();
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.getConfiguration().getRootLogger().addAppender((Appender)appender, Level.INFO, (Filter)ThresholdFilter.createFilter((Level)Level.INFO, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent(ContextRefreshedEvent event) throws IOException {
        if (this.propertiesConfig.getSendTestMailOnStartup()) {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            BuildInfoReader buildInfoReader = this.buildInfoReaderConfig.buildInfoReader();
            this.mailService().send("DSF BPE Test Mail", "BPE startup test mail\n\nArtifact: " + buildInfoReader.getProjectArtifact() + "\nVersion: " + buildInfoReader.getProjectVersion() + "\nBuild: " + buildInfoReader.getBuildDate().withZoneSameInstant(ZoneId.systemDefault()).format(formatter) + "\nBranch: " + buildInfoReader.getBuildBranch() + "\nCommit: " + buildInfoReader.getBuildNumber() + "\n\nSend on " + ZonedDateTime.now().withZoneSameInstant(ZoneId.systemDefault()).format(formatter));
        }
    }
}

