/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.bpe.variables.FhirResourceValues;
import dev.dsf.bpe.variables.VariablesImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FhirResourceSerializer
extends PrimitiveValueSerializer<FhirResourceValues.FhirResourceValue>
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FhirResourceSerializer.class);
    private final FhirContext fhirContext;

    public FhirResourceSerializer(FhirContext fhirContext) {
        super(FhirResourceValues.VALUE_TYPE);
        this.fhirContext = fhirContext;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.fhirContext, "fhirContext");
    }

    public void writeValue(FhirResourceValues.FhirResourceValue value, ValueFields valueFields) {
        Resource resource = (Resource)value.getValue();
        try {
            if (resource != null) {
                logger.trace("writeValue {} id: {}, parentActivityInstanceId: {}", new Object[]{resource.getResourceType().name(), resource.getIdElement().getIdPart(), resource.getUserData(VariablesImpl.TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID)});
                String s = this.newJsonParser().encodeResourceToString((IBaseResource)resource);
                valueFields.setTextValue(resource.getClass().getName());
                valueFields.setByteArrayValue(s.getBytes(StandardCharsets.UTF_8));
                Object parentActivityInstanceId = resource.getUserData(VariablesImpl.TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID);
                if (parentActivityInstanceId instanceof String) {
                    valueFields.setTextValue2((String)parentActivityInstanceId);
                }
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
    }

    private IParser newJsonParser() {
        IParser p = this.fhirContext.newJsonParser();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        return p;
    }

    public FhirResourceValues.FhirResourceValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return FhirResourceValues.create((Resource)untypedValue.getValue());
    }

    public FhirResourceValues.FhirResourceValue readValue(ValueFields valueFields, boolean asTransientValue) {
        String className = valueFields.getTextValue();
        byte[] bytes = valueFields.getByteArrayValue();
        String parentActivityInstanceId = valueFields.getTextValue2();
        try {
            Resource resource;
            if (className != null) {
                Class<?> clazz = Class.forName(className);
                resource = (Resource)this.newJsonParser().parseResource(clazz, (InputStream)new ByteArrayInputStream(bytes));
            } else {
                logger.warn("ClassName from DB null, trying to parse FHIR resource without type information");
                resource = (Resource)this.newJsonParser().parseResource((InputStream)new ByteArrayInputStream(bytes));
            }
            logger.trace("readValue {} id: {}, parentActivityInstanceId: {}", new Object[]{resource.getResourceType().name(), resource.getIdElement().getIdPart(), parentActivityInstanceId});
            if (parentActivityInstanceId instanceof String) {
                resource.setUserData(VariablesImpl.TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID, (Object)parentActivityInstanceId);
            }
            return FhirResourceValues.create(resource);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

