/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.bpe.dao.LastEventTimeDao;
import dev.dsf.bpe.subscription.EventResourceHandler;
import dev.dsf.bpe.subscription.ResourceHandler;
import java.sql.SQLException;
import java.util.Date;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventResourceHandlerImpl<R extends Resource>
implements EventResourceHandler<R> {
    private static final Logger logger = LoggerFactory.getLogger(EventResourceHandlerImpl.class);
    private final LastEventTimeDao lastEventTimeDao;
    private final ResourceHandler<R> handler;
    private final Class<R> resourceClass;

    public EventResourceHandlerImpl(LastEventTimeDao lastEventTimeDao, ResourceHandler<R> handler, Class<R> resourceClass) {
        this.lastEventTimeDao = lastEventTimeDao;
        this.handler = handler;
        this.resourceClass = resourceClass;
    }

    @Override
    public void onResource(Resource resource) {
        logger.trace("Resource of type {} received", (Object)resource.getClass().getAnnotation(ResourceDef.class).name());
        if (this.resourceClass.isInstance(resource)) {
            Resource cast = resource;
            this.handler.onResource(cast);
            this.writeLastEventTime(cast.getMeta().getLastUpdated());
        } else {
            logger.warn("Ignoring resource of type {}", (Object)resource.getClass().getAnnotation(ResourceDef.class).name());
        }
    }

    private void writeLastEventTime(Date lastUpdated) {
        try {
            this.lastEventTimeDao.writeLastEventTime(lastUpdated);
        }
        catch (SQLException e) {
            logger.warn("Unable to write last event time to db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

