/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import dev.dsf.bpe.spring.config.CamundaConfig;
import dev.dsf.bpe.spring.config.DaoConfig;
import dev.dsf.bpe.spring.config.FhirClientConfig;
import dev.dsf.bpe.spring.config.FhirConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.bpe.subscription.FhirConnector;
import dev.dsf.bpe.subscription.FhirConnectorImpl;
import dev.dsf.bpe.subscription.QuestionnaireResponseHandler;
import dev.dsf.bpe.subscription.QuestionnaireResponseSubscriptionHandlerFactory;
import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.bpe.subscription.SubscriptionHandlerFactory;
import dev.dsf.bpe.subscription.TaskHandler;
import dev.dsf.bpe.subscription.TaskSubscriptionHandlerFactory;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebsocketConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private CamundaConfig camundaConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private FhirClientConfig fhirClientConfig;

    @Bean
    public ResourceHandler<Task> taskHandler() {
        return new TaskHandler(this.camundaConfig.processEngine().getRuntimeService(), this.camundaConfig.processEngine().getRepositoryService(), this.fhirClientConfig.clientProvider().getLocalWebserviceClient());
    }

    @Bean
    public SubscriptionHandlerFactory<Task> taskSubscriptionHandlerFactory() {
        return new TaskSubscriptionHandlerFactory(this.taskHandler(), this.daoConfig.lastEventTimeDaoTask());
    }

    @Bean
    public FhirConnector fhirConnectorTask() {
        return new FhirConnectorImpl<Task>("Task", this.fhirClientConfig.clientProvider(), this.taskSubscriptionHandlerFactory(), this.fhirConfig.fhirContext(), this.propertiesConfig.getTaskSubscriptionSearchParameter(), this.propertiesConfig.getWebsocketRetrySleepMillis(), this.propertiesConfig.getWebsocketMaxRetries());
    }

    @Bean
    public ResourceHandler<QuestionnaireResponse> questionnaireResponseHandler() {
        return new QuestionnaireResponseHandler(this.camundaConfig.processEngine().getTaskService());
    }

    @Bean
    public SubscriptionHandlerFactory<QuestionnaireResponse> questionnaireResponseSubscriptionHandlerFactory() {
        return new QuestionnaireResponseSubscriptionHandlerFactory(this.questionnaireResponseHandler(), this.daoConfig.lastEventTimeDaoQuestionnaireResponse());
    }

    @Bean
    public FhirConnector fhirConnectorQuestionnaireResponse() {
        return new FhirConnectorImpl<QuestionnaireResponse>("QuestionnaireResponse", this.fhirClientConfig.clientProvider(), this.questionnaireResponseSubscriptionHandlerFactory(), this.fhirConfig.fhirContext(), this.propertiesConfig.getQuestionnaireResponseSubscriptionSearchParameter(), this.propertiesConfig.getWebsocketRetrySleepMillis(), this.propertiesConfig.getWebsocketMaxRetries());
    }
}

