/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import dev.dsf.bpe.camunda.DelegateProvider;
import dev.dsf.bpe.camunda.DelegateProviderImpl;
import dev.dsf.bpe.camunda.FallbackSerializerFactory;
import dev.dsf.bpe.camunda.FallbackSerializerFactoryImpl;
import dev.dsf.bpe.camunda.MultiVersionSpringProcessEngineConfiguration;
import dev.dsf.bpe.listener.ContinueListener;
import dev.dsf.bpe.listener.DebugLoggingBpmnParseListener;
import dev.dsf.bpe.listener.DefaultBpmnParseListener;
import dev.dsf.bpe.listener.EndListener;
import dev.dsf.bpe.listener.StartListener;
import dev.dsf.bpe.spring.config.FhirClientConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.bpe.spring.config.SerializerConfig;
import dev.dsf.bpe.variables.VariablesImpl;
import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.spring.ProcessEngineFactoryBean;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.postgresql.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class CamundaConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private FhirClientConfig fhirClientConfig;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SerializerConfig serializerConfig;

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new DataSourceTransactionManager((DataSource)this.camundaDataSource());
    }

    @Bean
    public TransactionAwareDataSourceProxy transactionAwareDataSource() {
        return new TransactionAwareDataSourceProxy((DataSource)this.camundaDataSource());
    }

    @Bean
    public BasicDataSource camundaDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUrl(this.propertiesConfig.getDbUrl());
        dataSource.setUsername(this.propertiesConfig.getDbCamundaUsername());
        dataSource.setPassword(this.toString(this.propertiesConfig.getDbCamundaPassword()));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }

    @Bean
    public StartListener startListener() {
        return new StartListener(this.propertiesConfig.getServerBaseUrl(), VariablesImpl::new);
    }

    @Bean
    public EndListener endListener() {
        return new EndListener(this.propertiesConfig.getServerBaseUrl(), VariablesImpl::new, this.fhirClientConfig.clientProvider().getLocalWebserviceClient());
    }

    @Bean
    public ContinueListener continueListener() {
        return new ContinueListener(this.propertiesConfig.getServerBaseUrl(), VariablesImpl::new);
    }

    @Bean
    public DefaultBpmnParseListener defaultBpmnParseListener() {
        return new DefaultBpmnParseListener(this.startListener(), this.endListener(), this.continueListener());
    }

    @Bean
    public DebugLoggingBpmnParseListener debugLoggingBpmnParseListener() {
        return new DebugLoggingBpmnParseListener(this.propertiesConfig.getDebugLogMessageOnActivityStart(), this.propertiesConfig.getDebugLogMessageOnActivityEnd(), this.propertiesConfig.getDebugLogMessageVariables());
    }

    @Bean
    public SpringProcessEngineConfiguration processEngineConfiguration() {
        MultiVersionSpringProcessEngineConfiguration c = new MultiVersionSpringProcessEngineConfiguration(this.delegateProvider());
        c.setProcessEngineName("dsf");
        c.setDataSource((DataSource)this.transactionAwareDataSource());
        c.setTransactionManager(this.transactionManager());
        c.setDatabaseSchemaUpdate("false");
        c.setJobExecutorActivate(false);
        c.setCustomPreBPMNParseListeners(List.of(this.defaultBpmnParseListener(), this.debugLoggingBpmnParseListener()));
        c.setCustomPreVariableSerializers(List.of(this.serializerConfig.targetSerializer(), this.serializerConfig.targetsSerializer(), this.serializerConfig.fhirResourceSerializer(), this.serializerConfig.fhirResourcesListSerializer()));
        c.setFallbackSerializerFactory(this.fallbackSerializerFactory());
        c.setInitializeTelemetry(false);
        c.setTelemetryReporterActivate(false);
        return c;
    }

    @Bean
    public FallbackSerializerFactory fallbackSerializerFactory() {
        return new FallbackSerializerFactoryImpl();
    }

    @Bean
    public DelegateProvider delegateProvider() {
        return new DelegateProviderImpl(ClassLoader.getSystemClassLoader(), this.applicationContext);
    }

    @Bean
    public ProcessEngineFactoryBean processEngineFactory() throws IOException {
        ProcessEngineFactoryBean f = new ProcessEngineFactoryBean();
        f.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)this.processEngineConfiguration());
        return f;
    }

    public ProcessEngine processEngine() {
        try {
            return this.processEngineFactory().getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

