/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import dev.dsf.bpe.camunda.ProcessPluginConsumer;
import dev.dsf.bpe.plugin.BpmnFileAndModel;
import dev.dsf.bpe.plugin.BpmnProcessStateChangeService;
import dev.dsf.bpe.plugin.FhirResourceHandler;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessPlugin;
import dev.dsf.bpe.plugin.ProcessPluginLoader;
import dev.dsf.bpe.plugin.ProcessPluginManager;
import dev.dsf.bpe.plugin.ProcessState;
import dev.dsf.bpe.plugin.ProcessStateChangeOutcome;
import dev.dsf.bpe.v1.ProcessPluginDeplyomentStateListener;
import dev.dsf.bpe.v1.constants.NamingSystems;
import dev.dsf.fhir.client.BasicFhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ProcessPluginManagerImpl
implements ProcessPluginManager,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPluginManagerImpl.class);
    private final List<ProcessPluginConsumer> processPluginConsumers = new ArrayList<ProcessPluginConsumer>();
    private final ProcessPluginLoader processPluginLoader;
    private final BpmnProcessStateChangeService bpmnProcessStateChangeService;
    private final FhirResourceHandler fhirResourceHandler;
    private final String localEndpointAddress;
    private final FhirWebserviceClient localWebserviceClient;
    private final int fhirServerRequestMaxRetries;
    private final long fhirServerRetryDelayMillis;

    public ProcessPluginManagerImpl(List<ProcessPluginConsumer> processPluginConsumers, ProcessPluginLoader processPluginLoader, BpmnProcessStateChangeService bpmnProcessStateChangeService, FhirResourceHandler fhirResourceHandler, String localEndpointAddress, FhirWebserviceClient localWebserviceClient, int fhirServerRequestMaxRetries, long fhirServerRetryDelayMillis) {
        if (processPluginConsumers != null) {
            this.processPluginConsumers.addAll(processPluginConsumers);
        }
        this.processPluginLoader = processPluginLoader;
        this.bpmnProcessStateChangeService = bpmnProcessStateChangeService;
        this.fhirResourceHandler = fhirResourceHandler;
        this.localEndpointAddress = localEndpointAddress;
        this.localWebserviceClient = localWebserviceClient;
        this.fhirServerRequestMaxRetries = fhirServerRequestMaxRetries;
        this.fhirServerRetryDelayMillis = fhirServerRetryDelayMillis;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.processPluginLoader, "processPluginLoader");
        Objects.requireNonNull(this.bpmnProcessStateChangeService, "bpmnProcessStateChangeService");
        Objects.requireNonNull(this.fhirResourceHandler, "fhirResourceHandler");
        Objects.requireNonNull(this.localEndpointAddress, "localEndpointAddress");
        Objects.requireNonNull(this.localWebserviceClient, "localWebserviceClient");
    }

    @Override
    public void loadAndDeployPlugins() {
        List<ProcessPlugin<?, ?>> plugins;
        Optional<String> localOrganizationIdentifierValue = this.getLocalOrganizationIdentifierValue();
        if (localOrganizationIdentifierValue.isEmpty()) {
            logger.warn("Local organization identifier unknown, check DSF FHIR server allow list");
        }
        if ((plugins = this.removeDuplicates(this.processPluginLoader.loadPlugins().stream().filter(p -> p.initializeAndValidateResources(localOrganizationIdentifierValue.orElse(null))))).isEmpty()) {
            logger.warn("No process plugins deployed");
        }
        this.processPluginConsumers.forEach(c -> c.setProcessPlugins(plugins));
        List<BpmnFileAndModel> models = plugins.stream().flatMap(p -> p.getProcessModels().stream()).toList();
        List<ProcessStateChangeOutcome> outcomes = this.bpmnProcessStateChangeService.deploySuspendOrActivateProcesses(models);
        Map<ProcessIdAndVersion, List<Resource>> resources = plugins.stream().map(ProcessPlugin::getFhirResources).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.fhirResourceHandler.applyStateChangesAndStoreNewResourcesInDb(resources, outcomes);
        this.onProcessesDeployed(outcomes, plugins);
    }

    private BasicFhirWebserviceClient retryClient() {
        if (this.fhirServerRequestMaxRetries == -1) {
            return (BasicFhirWebserviceClient)this.localWebserviceClient.withRetryForever(this.fhirServerRetryDelayMillis);
        }
        return (BasicFhirWebserviceClient)this.localWebserviceClient.withRetry(this.fhirServerRequestMaxRetries, this.fhirServerRetryDelayMillis);
    }

    private Optional<String> getLocalOrganizationIdentifierValue() {
        Bundle resultBundle = this.retryClient().searchWithStrictHandling(Endpoint.class, Map.of("status", Collections.singletonList("active"), "address", Collections.singletonList(this.localEndpointAddress), "_include", Collections.singletonList("Endpoint:organization")));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getEntry().size() != 2 || ((Bundle.BundleEntryComponent)resultBundle.getEntry().get(0)).getResource() == null || !(((Bundle.BundleEntryComponent)resultBundle.getEntry().get(0)).getResource() instanceof Endpoint) || ((Bundle.BundleEntryComponent)resultBundle.getEntry().get(1)).getResource() == null || !(((Bundle.BundleEntryComponent)resultBundle.getEntry().get(1)).getResource() instanceof Organization)) {
            logger.warn("No active (or more than one) Endpoint found for address '{}'", (Object)this.localEndpointAddress);
            return Optional.empty();
        }
        if (this.getActiveOrganizationFromIncludes(resultBundle).count() != 1L) {
            logger.warn("No active (or more than one) Organization found by active Endpoint with address '{}'", (Object)this.localEndpointAddress);
            return Optional.empty();
        }
        return this.getActiveOrganizationFromIncludes(resultBundle).findFirst().flatMap(NamingSystems.OrganizationIdentifier::findFirst).map(Identifier::getValue);
    }

    private Stream<Organization> getActiveOrganizationFromIncludes(Bundle resultBundle) {
        return resultBundle.getEntry().stream().filter(Bundle.BundleEntryComponent::hasSearch).filter(e -> Bundle.SearchEntryMode.INCLUDE.equals((Object)e.getSearch().getMode())).filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(r -> r instanceof Organization).map(r -> (Organization)r).filter(Organization::getActive);
    }

    private List<ProcessPlugin<?, ?>> removeDuplicates(Stream<ProcessPlugin<?, ?>> plugins) {
        HashMap pluginsByProcessIdAndVersion = new HashMap();
        plugins.forEach(plugin -> {
            List<ProcessIdAndVersion> processes = plugin.getProcessKeysAndVersions();
            for (ProcessIdAndVersion process : processes) {
                if (pluginsByProcessIdAndVersion.containsKey(process)) {
                    ((List)pluginsByProcessIdAndVersion.get(process)).add(plugin);
                    continue;
                }
                ArrayList<ProcessPlugin> list = new ArrayList<ProcessPlugin>();
                list.add((ProcessPlugin)plugin);
                pluginsByProcessIdAndVersion.put(process, list);
            }
        });
        pluginsByProcessIdAndVersion.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> logger.warn("Ignoring process plugins {} with duplicated process {}", (Object)((List)e.getValue()).stream().map(ProcessPlugin::getJarFile).map(Path::toString).collect(Collectors.joining(", ")), (Object)((ProcessIdAndVersion)e.getKey()).toString()));
        return pluginsByProcessIdAndVersion.entrySet().stream().filter(e -> ((List)e.getValue()).size() == 1).flatMap(e -> ((List)e.getValue()).stream()).distinct().toList();
    }

    private void onProcessesDeployed(List<ProcessStateChangeOutcome> changes, List<ProcessPlugin<?, ?>> plugins) {
        Set activeProcesses = changes.stream().filter(c -> EnumSet.of(ProcessState.ACTIVE, ProcessState.DRAFT).contains((Object)c.getNewProcessState())).map(ProcessStateChangeOutcome::getProcessKeyAndVersion).collect(Collectors.toSet());
        plugins.forEach(plugin -> {
            List<String> activePluginProcesses = plugin.getProcessKeysAndVersions().stream().filter(activeProcesses::contains).map(ProcessIdAndVersion::getId).toList();
            plugin.getApplicationContext().getBeansOfType(ProcessPluginDeplyomentStateListener.class).entrySet().forEach(this.onProcessesDeployed((ProcessPlugin<?, ?>)plugin, activePluginProcesses));
        });
    }

    private Consumer<Map.Entry<String, ProcessPluginDeplyomentStateListener>> onProcessesDeployed(ProcessPlugin<?, ?> plugin, List<String> activePluginProcesses) {
        return entry -> {
            try {
                ((ProcessPluginDeplyomentStateListener)entry.getValue()).onProcessesDeployed(activePluginProcesses);
            }
            catch (Exception e) {
                logger.warn("Error while executing {} bean {} for process plugin {}, {} - {}", new Object[]{ProcessPluginDeplyomentStateListener.class.getName(), entry.getKey(), plugin.getJarFile().toString(), e.getClass().getName(), e.getMessage()});
                logger.debug("Error while executing " + ProcessPluginDeplyomentStateListener.class.getName() + " bean " + (String)entry.getKey() + " for process plugin " + plugin.getJarFile().toString(), (Throwable)e);
            }
        };
    }
}

