/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.dao;

import ca.uhn.fhir.parser.DataFormatException;
import dev.dsf.bpe.dao.AbstractDaoJdbc;
import dev.dsf.bpe.dao.ProcessPluginResourcesDao;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessesResource;
import dev.dsf.bpe.plugin.ResourceInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hl7.fhir.r4.model.ResourceType;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPluginResourcesDaoJdbc
extends AbstractDaoJdbc
implements ProcessPluginResourcesDao {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPluginResourcesDaoJdbc.class);

    public ProcessPluginResourcesDaoJdbc(BasicDataSource dataSource) {
        super(dataSource);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<ProcessIdAndVersion, List<ResourceInfo>> getResources() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addOrRemoveResources(Collection<? extends ProcessesResource> newResources, List<UUID> deletedResourcesIds, List<ProcessIdAndVersion> excludedProcesses) throws SQLException {
        Objects.requireNonNull(newResources, "newResources");
        Objects.requireNonNull(deletedResourcesIds, "deletedResourcesIds");
        Objects.requireNonNull(excludedProcesses, "excludedProcesses");
        if (newResources.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement statement;
            connection.setReadOnly(false);
            connection.setAutoCommit(false);
            for (ProcessesResource processesResource : newResources) {
                for (ProcessIdAndVersion process : processesResource.getProcesses()) {
                    PreparedStatement statement2;
                    ResourceInfo resourceInfo;
                    ResourceType resourceType = processesResource.getResourceInfo().getResourceType();
                    if (!ResourceType.NamingSystem.equals((Object)resourceType) && !ResourceType.Task.equals((Object)resourceType)) {
                        try {
                            PreparedStatement statement22 = connection.prepareStatement("INSERT INTO process_plugin_resources (process_key_and_version, resource_type, resource_id, url, version) VALUES (?, ?, ?, ?, ?) ON CONFLICT (process_key_and_version, resource_type, url, version) WHERE resource_type <> 'NamingSystem' DO UPDATE SET resource_id = ?");
                            try {
                                resourceInfo = processesResource.getResourceInfo();
                                statement22.setString(1, process.toString());
                                statement22.setString(2, resourceType.name());
                                statement22.setObject(3, this.uuidToPgObject(resourceInfo.getResourceId()));
                                statement22.setString(4, resourceInfo.getUrl());
                                statement22.setString(5, resourceInfo.getVersion());
                                statement22.setObject(6, this.uuidToPgObject(resourceInfo.getResourceId()));
                                statement22.addBatch();
                                logger.trace("Executing query '{}'", (Object)statement22);
                                statement22.executeBatch();
                                continue;
                            }
                            finally {
                                if (statement22 == null) continue;
                                statement22.close();
                                continue;
                            }
                        }
                        catch (SQLException e) {
                            connection.rollback();
                            throw e;
                        }
                    }
                    if (ResourceType.NamingSystem.equals((Object)resourceType)) {
                        try {
                            statement2 = connection.prepareStatement("INSERT INTO process_plugin_resources (process_key_and_version, resource_type, resource_id, name) VALUES (?, 'NamingSystem', ?, ?) ON CONFLICT (process_key_and_version, resource_type, name) WHERE resource_type = 'NamingSystem' DO UPDATE SET resource_id = ?");
                            try {
                                resourceInfo = processesResource.getResourceInfo();
                                statement2.setString(1, process.toString());
                                statement2.setObject(2, this.uuidToPgObject(resourceInfo.getResourceId()));
                                statement2.setString(3, resourceInfo.getName());
                                statement2.setObject(4, this.uuidToPgObject(resourceInfo.getResourceId()));
                                statement2.addBatch();
                                logger.trace("Executing query '{}'", (Object)statement2);
                                statement2.executeBatch();
                                continue;
                            }
                            finally {
                                if (statement2 == null) continue;
                                statement2.close();
                                continue;
                            }
                        }
                        catch (SQLException e) {
                            connection.rollback();
                            throw e;
                        }
                    }
                    if (!ResourceType.Task.equals((Object)resourceType)) continue;
                    try {
                        statement2 = connection.prepareStatement("INSERT INTO process_plugin_resources (process_key_and_version, resource_type, resource_id, identifier) VALUES (?, 'Task', ?, ?) ON CONFLICT (process_key_and_version, resource_type, identifier) WHERE resource_type = 'Task' DO UPDATE SET resource_id = ?");
                        try {
                            resourceInfo = processesResource.getResourceInfo();
                            statement2.setString(1, process.toString());
                            statement2.setObject(2, this.uuidToPgObject(resourceInfo.getResourceId()));
                            statement2.setString(3, resourceInfo.getIdentifier());
                            statement2.setObject(4, this.uuidToPgObject(resourceInfo.getResourceId()));
                            statement2.addBatch();
                            logger.trace("Executing query '{}'", (Object)statement2);
                            statement2.executeBatch();
                        }
                        finally {
                            if (statement2 == null) continue;
                            statement2.close();
                        }
                    }
                    catch (SQLException e) {
                        connection.rollback();
                        throw e;
                    }
                }
            }
            try {
                statement = connection.prepareStatement("DELETE FROM process_plugin_resources WHERE resource_id = ?");
                try {
                    for (UUID deletedId : deletedResourcesIds) {
                        statement.setObject(1, this.uuidToPgObject(deletedId));
                        statement.addBatch();
                        logger.trace("Executing query '{}'", (Object)statement);
                    }
                    statement.executeBatch();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            try {
                statement = connection.prepareStatement("DELETE FROM process_plugin_resources WHERE process_key_and_version = ?");
                try {
                    for (ProcessIdAndVersion process : excludedProcesses) {
                        statement.setString(1, process.toString());
                        statement.addBatch();
                        logger.trace("Executing query '{}'", (Object)statement);
                    }
                    statement.executeBatch();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            connection.commit();
        }
    }

    private PGobject uuidToPgObject(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            PGobject o = new PGobject();
            o.setType("UUID");
            o.setValue(uuid.toString());
            return o;
        }
        catch (DataFormatException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

