/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe;

import dev.dsf.bpe.config.BpeDbMigratorConfig;
import dev.dsf.bpe.config.BpeHttpJettyConfig;
import dev.dsf.common.jetty.JettyServer;
import dev.dsf.common.jetty.Log4jInitializer;
import dev.dsf.tools.db.DbMigrator;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class BpeJettyServer {
    private BpeJettyServer() {
    }

    public static void main(String[] args) {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{BpeDbMigratorConfig.class});){
            DbMigrator migrator = (DbMigrator)context.getBean(DbMigrator.class);
            DbMigrator.retryOnConnectException((int)3, () -> ((DbMigrator)migrator).migrate());
        }
        context = new AnnotationConfigApplicationContext(new Class[]{BpeHttpJettyConfig.class});
        try {
            JettyServer server = (JettyServer)context.getBean(JettyServer.class);
            server.start();
        }
        finally {
            context.close();
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Log4jInitializer.initializeLog4j();
    }
}

