/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe;

import dev.dsf.bpe.BpeDbMigratorConfig;
import dev.dsf.common.jetty.JettyConfig;
import dev.dsf.common.jetty.JettyServer;
import dev.dsf.tools.db.DbMigrator;
import dev.dsf.tools.db.DbMigratorConfig;
import java.util.stream.Stream;
import org.glassfish.jersey.servlet.init.JerseyServletContainerInitializer;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.SpringServletContainerInitializer;

public final class BpeServer
extends JettyServer {
    public BpeServer(JettyConfig jettyConfig) {
        super("bpe-server", jettyConfig, Stream.of(JerseyServletContainerInitializer.class, SpringServletContainerInitializer.class));
    }

    public void beforeStart() {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{BpeDbMigratorConfig.class});){
            DbMigratorConfig config = (DbMigratorConfig)context.getBean(DbMigratorConfig.class);
            DbMigrator dbMigrator = new DbMigrator(config);
            DbMigrator.retryOnConnectException((int)3, () -> ((DbMigrator)dbMigrator).migrate());
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

