/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe;

import dev.dsf.common.documentation.Documentation;
import dev.dsf.tools.db.DbMigratorConfig;
import dev.dsf.tools.docker.secrets.DockerSecretsPropertySourceFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@PropertySource(value={"file:conf/config.properties"}, encoding="UTF-8", ignoreResourceNotFound=true)
public class BpeDbMigratorConfig
implements DbMigratorConfig {
    private static final String DB_LIQUIBASE_USER = "db.liquibase_user";
    private static final String DB_SERVER_USERS_GROUP = "db.server_users_group";
    private static final String DB_SERVER_USER = "db.server_user";
    private static final String DB_SERVER_USER_PASSWORD = "db.server_user_password";
    private static final String DB_CAMUNDA_USERS_GROUP = "db.camunda_users_group";
    private static final String DB_CAMUNDA_USER = "db.camunda_user";
    private static final String DB_CAMUNDA_USER_PASSWORD = "db.camunda_user_password";
    @Value(value="${dev.dsf.bpe.db.url}")
    private String dbUrl;
    @Documentation(description="The user name to access the database from the DSF BPE server to execute database migrations")
    @Value(value="${dev.dsf.bpe.db.liquibase.username:liquibase_user}")
    private String dbLiquibaseUsername;
    @Documentation(required=true, description="The password to access the database from the DSF BPE server to execute database migrations", recommendation="Use docker secret file to configure by using *${env_variable}_FILE*", example="/run/secrets/db_liquibase.password")
    @Value(value="${dev.dsf.bpe.db.liquibase.password}")
    private char[] dbLiquibasePassword;
    @Documentation(description="The name of the user group to access the database from the DSF BPE server")
    @Value(value="${dev.dsf.bpe.db.user.group:bpe_users}")
    private String dbUsersGroup;
    @Value(value="${dev.dsf.bpe.db.user.username:bpe_server_user}")
    private String dbUsername;
    @Value(value="${dev.dsf.bpe.db.user.password}")
    private char[] dbPassword;
    @Documentation(description="The name of the user group to access the database from the DSF BPE server for camunda processes")
    @Value(value="${dev.dsf.bpe.db.user.camunda.group:camunda_users}")
    private String dbCamundaUsersGroup;
    @Value(value="${dev.dsf.bpe.db.user.camunda.username:camunda_server_user}")
    private String dbCamundaUsername;
    @Value(value="${dev.dsf.bpe.db.user.camunda.password}")
    private char[] dbCamundaPassword;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment environment) {
        new DockerSecretsPropertySourceFactory(environment).readDockerSecretsAndAddPropertiesToEnvironment();
        return new PropertySourcesPlaceholderConfigurer();
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbLiquibaseUsername() {
        return this.dbLiquibaseUsername;
    }

    public char[] getDbLiquibasePassword() {
        return this.dbLiquibasePassword;
    }

    public Map<String, String> getChangeLogParameters() {
        return Map.of(DB_LIQUIBASE_USER, this.dbLiquibaseUsername, DB_SERVER_USERS_GROUP, this.dbUsersGroup, DB_SERVER_USER, this.dbUsername, DB_SERVER_USER_PASSWORD, this.toString(this.dbPassword), DB_CAMUNDA_USERS_GROUP, this.dbCamundaUsersGroup, DB_CAMUNDA_USER, this.dbCamundaUsername, DB_CAMUNDA_USER_PASSWORD, this.toString(this.dbCamundaPassword));
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }
}

