/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;

public interface TaskHelper {
    public String getLocalVersionlessAbsoluteUrl(Task var1);

    default public Optional<String> getFirstInputParameterStringValue(Task task, Coding coding) {
        return this.getInputParameterStringValues(task, coding).findFirst();
    }

    default public Optional<String> getFirstInputParameterStringValue(Task task, String system, String code) {
        return this.getInputParameterStringValues(task, system, code).findFirst();
    }

    default public <T extends Type> Optional<T> getFirstInputParameterValue(Task task, Coding coding, Class<T> expectedType) {
        return this.getInputParameterValues(task, coding, expectedType).findFirst();
    }

    default public <T extends Type> Optional<T> getFirstInputParameterValue(Task task, String system, String code, Class<T> expectedType) {
        return this.getInputParameterValues(task, system, code, expectedType).findFirst();
    }

    default public Optional<Task.ParameterComponent> getFirstInputParameterWithExtension(Task task, Coding coding, Class<? extends Type> expectedType, String extensionUrl) {
        return this.getInputParametersWithExtension(task, coding, expectedType, extensionUrl).findFirst();
    }

    default public Optional<Task.ParameterComponent> getFirstInputParameterWithExtension(Task task, String system, String code, Class<? extends Type> expectedType, String extensionUrl) {
        return this.getInputParametersWithExtension(task, system, code, expectedType, extensionUrl).findFirst();
    }

    default public Optional<Task.ParameterComponent> getFirstInputParameter(Task task, Coding coding, Class<? extends Type> expectedType) {
        return this.getInputParameters(task, coding, expectedType).findFirst();
    }

    default public Optional<Task.ParameterComponent> getFirstInputParameter(Task task, String system, String code, Class<? extends Type> expectedType) {
        return this.getInputParameters(task, system, code, expectedType).findFirst();
    }

    public Stream<String> getInputParameterStringValues(Task var1, Coding var2);

    public Stream<String> getInputParameterStringValues(Task var1, String var2, String var3);

    public <T extends Type> Stream<T> getInputParameterValues(Task var1, Coding var2, Class<T> var3);

    public <T extends Type> Stream<T> getInputParameterValues(Task var1, String var2, String var3, Class<T> var4);

    public Stream<Task.ParameterComponent> getInputParametersWithExtension(Task var1, Coding var2, Class<? extends Type> var3, String var4);

    public Stream<Task.ParameterComponent> getInputParametersWithExtension(Task var1, String var2, String var3, Class<? extends Type> var4, String var5);

    public Stream<Task.ParameterComponent> getInputParameters(Task var1, Coding var2, Class<? extends Type> var3);

    public Stream<Task.ParameterComponent> getInputParameters(Task var1, String var2, String var3, Class<? extends Type> var4);

    public Task.ParameterComponent createInput(Type var1, Coding var2);

    public Task.ParameterComponent createInput(Type var1, String var2, String var3);

    public Task.TaskOutputComponent createOutput(Type var1, Coding var2);

    public Task.TaskOutputComponent createOutput(Type var1, String var2, String var3);
}

