/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

public interface MailService {
    default public void send(String subject, String message) {
        this.send(subject, message, (String)null);
    }

    default public void send(String subject, String message, String to) {
        this.send(subject, message, to == null ? null : Collections.singleton(to));
    }

    default public void send(String subject, String message, Collection<String> to) {
        try {
            MimeBodyPart body = new MimeBodyPart();
            body.setText(message, StandardCharsets.UTF_8.displayName());
            this.send(subject, body, to);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    default public void send(String subject, MimeBodyPart body) {
        this.send(subject, body, (String)null);
    }

    default public void send(String subject, MimeBodyPart body, String to) {
        this.send(subject, body, to == null ? null : Collections.singleton(to));
    }

    default public void send(String subject, MimeBodyPart body, Collection<String> to) {
        if (to == null || to.isEmpty()) {
            this.send(subject, body, (Consumer<MimeMessage>)null);
        } else {
            this.send(subject, body, (MimeMessage m) -> {
                try {
                    m.setRecipients(Message.RecipientType.TO, (Address[])to.stream().map(t -> {
                        try {
                            return new InternetAddress(t);
                        }
                        catch (AddressException e) {
                            throw new RuntimeException(e);
                        }
                    }).toArray(InternetAddress[]::new));
                    m.saveChanges();
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public void send(String var1, MimeBodyPart var2, Consumer<MimeMessage> var3);
}

