/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.constants.NamingSystems;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Identifier;

public interface EndpointProvider {
    public String getLocalEndpointAddress();

    public Optional<Endpoint> getLocalEndpoint();

    default public Optional<Identifier> getLocalEndpointIdentifier() {
        return NamingSystems.EndpointIdentifier.findFirst(this.getLocalEndpoint());
    }

    default public Optional<String> getLocalEndpointIdentifierValue() {
        return this.getLocalEndpointIdentifier().map(Identifier::getValue);
    }

    public Optional<Endpoint> getEndpoint(Identifier var1);

    default public Optional<Endpoint> getEndpoint(String endpointIdentifierValue) {
        return this.getEndpoint(endpointIdentifierValue == null ? null : NamingSystems.EndpointIdentifier.withValue(endpointIdentifierValue));
    }

    default public Optional<String> getEndpointAddress(Identifier endpointIdentifier) {
        return this.getEndpoint(endpointIdentifier).map(Endpoint::getAddress);
    }

    default public Optional<String> getEndpointAddress(String endpointIdentifierValue) {
        return this.getEndpointAddress(endpointIdentifierValue == null ? null : NamingSystems.EndpointIdentifier.withValue(endpointIdentifierValue));
    }

    public Optional<Endpoint> getEndpoint(Identifier var1, Identifier var2, Coding var3);

    default public Optional<Endpoint> getEndpoint(String parentOrganizationIdentifierValue, String memberOrganizationIdentifierValue, Coding memberOrganizationRole) {
        return this.getEndpoint(parentOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(parentOrganizationIdentifierValue), memberOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(memberOrganizationIdentifierValue), memberOrganizationRole);
    }

    default public Optional<String> getEndpointAddress(Identifier parentOrganizationIdentifier, Identifier memberOrganizationIdentifier, Coding memberOrganizationRole) {
        return this.getEndpoint(parentOrganizationIdentifier, memberOrganizationIdentifier, memberOrganizationRole).map(Endpoint::getAddress);
    }

    default public Optional<String> getEndpointAddress(String parentOrganizationIdentifierValue, String memberOrganizationIdentifierValue, Coding memberOrganizationRole) {
        return this.getEndpointAddress(parentOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(parentOrganizationIdentifierValue), memberOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(memberOrganizationIdentifierValue), memberOrganizationRole);
    }

    public List<Endpoint> getEndpoints(Identifier var1, Coding var2);

    default public List<Endpoint> getEndpoints(String parentOrganizationIdentifierValue, Coding memberOrganizationRole) {
        return this.getEndpoints(parentOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(parentOrganizationIdentifierValue), memberOrganizationRole);
    }
}

