/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.start;

import ca.uhn.fhir.context.FhirContext;
import de.rwh.utils.crypto.CertificateHelper;
import de.rwh.utils.crypto.io.CertificateReader;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceCleanerImpl;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceExtractorImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Task;

public class ExampleStarter {
    private final String certificatePath;
    private final char[] certificatePassword;
    private final String baseUrl;

    public static ExampleStarter forServer(String[] args, String baseUrl) {
        String certificatePath = System.getenv("DSF_CLIENT_CERTIFICATE_PATH");
        String certificatePassword = System.getenv("DSF_CLIENT_CERTIFICATE_PASSWORD");
        if (args.length > 0 && !args[0].isBlank()) {
            certificatePath = args[0];
        }
        if (args.length > 1 && !args[1].isBlank()) {
            certificatePassword = args[1];
        }
        return ExampleStarter.forServer(certificatePath, certificatePassword, baseUrl);
    }

    public static ExampleStarter forServer(String certificatePath, String certificatePassword, String baseUrl) {
        if (certificatePath == null || certificatePath.isBlank()) {
            throw new IllegalArgumentException("certificatePath null or blank");
        }
        if (certificatePassword == null || certificatePassword.isBlank()) {
            throw new IllegalArgumentException("certificatePassword null or blank");
        }
        if (baseUrl == null || baseUrl.isBlank()) {
            throw new IllegalArgumentException("baseUrl null or blank");
        }
        return new ExampleStarter(certificatePath, certificatePassword, baseUrl);
    }

    private ExampleStarter(String certificatePath, String certificatePassword, String baseUrl) {
        this.certificatePath = certificatePath;
        this.certificatePassword = certificatePassword.toCharArray();
        this.baseUrl = baseUrl;
    }

    public void startWith(Task task) throws Exception {
        this.start((Resource)task);
    }

    public void startWith(Bundle bundle) throws Exception {
        this.start((Resource)bundle);
    }

    private void start(Resource resource) throws Exception {
        FhirWebserviceClient client = this.createClient(this.baseUrl);
        if (resource instanceof Bundle) {
            Bundle bundle = (Bundle)resource;
            bundle.getEntry().stream().map(e -> e.getResource().getResourceType()).filter(arg_0 -> ResourceType.Task.equals(arg_0)).findFirst().orElseThrow(() -> new IllegalArgumentException("Bundle does not contain a Task resource"));
            client.withMinimalReturn().postBundle(bundle);
        } else if (resource instanceof Task) {
            client.withMinimalReturn().create(resource);
        } else {
            throw new IllegalArgumentException("Resource should be of type Bundle or Task");
        }
    }

    public FhirWebserviceClient createClient(String baseUrl) throws Exception {
        KeyStore keyStore = CertificateReader.fromPkcs12((Path)Paths.get(this.certificatePath, new String[0]), (char[])this.certificatePassword);
        KeyStore trustStore = CertificateHelper.extractTrust((KeyStore)keyStore);
        FhirContext context = FhirContext.forR4();
        ReferenceCleanerImpl referenceCleaner = new ReferenceCleanerImpl((ReferenceExtractor)new ReferenceExtractorImpl());
        return new FhirWebserviceClientJersey(baseUrl, trustStore, keyStore, this.certificatePassword, null, null, null, null, 0, 0, false, "DSF Example Starter", context, (ReferenceCleaner)referenceCleaner);
    }
}

