/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.constants.NamingSystems;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;

public interface OrganizationProvider {
    public Optional<Organization> getLocalOrganization();

    default public Optional<Identifier> getLocalOrganizationIdentifier() {
        return NamingSystems.OrganizationIdentifier.findFirst(this.getLocalOrganization());
    }

    default public Optional<String> getLocalOrganizationIdentifierValue() {
        return this.getLocalOrganizationIdentifier().map(Identifier::getValue);
    }

    public Optional<Organization> getOrganization(Identifier var1);

    default public Optional<Organization> getOrganization(String organizationIdentifierValue) {
        return this.getOrganization(organizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(organizationIdentifierValue));
    }

    public List<Organization> getOrganizations(Identifier var1);

    default public List<Organization> getOrganizations(String parentOrganizationIdentifierValue) {
        return this.getOrganizations(parentOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(parentOrganizationIdentifierValue));
    }

    public List<Organization> getOrganizations(Identifier var1, Coding var2);

    default public List<Organization> getOrganizations(String parentOrganizationIdentifierValue, Coding memberOrganizationRole) {
        return this.getOrganizations(parentOrganizationIdentifierValue == null ? null : NamingSystems.OrganizationIdentifier.withValue(parentOrganizationIdentifierValue), memberOrganizationRole);
    }

    public List<Organization> getRemoteOrganizations();
}

