/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ProcessPluginDefinition {
    public static final String RESOURCE_VERSION_PATTERN_STRING = "(?<resourceVersion>\\d+\\.\\d+)";
    public static final String PLUGIN_VERSION_PATTERN_STRING = "(?<pluginVersion>(?<resourceVersion>\\d+\\.\\d+)\\.\\d+\\.\\d+)";
    public static final Pattern PLUGIN_VERSION_PATTERN = Pattern.compile("(?<pluginVersion>(?<resourceVersion>\\d+\\.\\d+)\\.\\d+\\.\\d+)");

    public String getName();

    public String getVersion();

    default public String getResourceVersion() {
        if (this.getVersion() == null) {
            return null;
        }
        Matcher matcher = PLUGIN_VERSION_PATTERN.matcher(this.getVersion());
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group("resourceVersion");
    }

    public LocalDate getReleaseDate();

    default public LocalDate getResourceReleaseDate() {
        return this.getReleaseDate();
    }

    public List<String> getProcessModels();

    public Map<String, List<String>> getFhirResourcesByProcessId();

    public List<Class<?>> getSpringConfigurations();
}

