/*
 * Decompiled with CFR 0.152.
 */
package dev.dovydasvenckus.scrapper.client;

import dev.dovydasvenckus.scrapper.client.jackson.KotlinObjectMapperProvider;
import dev.dovydasvenckus.scrapper.client.model.ScrapeRequest;
import dev.dovydasvenckus.scrapper.client.model.ScrapeResult;
import dev.dovydasvenckus.scrapper.client.service.ScrapingService;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/dovydasvenckus/scrapper/client/WebScrapperClient;", "", "webScraperApiUrl", "", "(Ljava/lang/String;)V", "client", "Ljavax/ws/rs/client/Client;", "scrapingService", "Ldev/dovydasvenckus/scrapper/client/service/ScrapingService;", "scrape", "Ldev/dovydasvenckus/scrapper/client/model/ScrapeResult;", "request", "Ldev/dovydasvenckus/scrapper/client/model/ScrapeRequest;", "web-scrapper-java-client"})
public final class WebScrapperClient {
    @NotNull
    private final ScrapingService scrapingService;
    @NotNull
    private final Client client;

    public WebScrapperClient(@NotNull String webScraperApiUrl) {
        Intrinsics.checkNotNullParameter((Object)webScraperApiUrl, (String)"webScraperApiUrl");
        this.scrapingService = new ScrapingService(webScraperApiUrl);
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(KotlinObjectMapperProvider.class)).build();
        Intrinsics.checkNotNullExpressionValue((Object)client, (String)"newBuilder()\n        .register(KotlinObjectMapperProvider::class.java)\n        .build()");
        this.client = client;
    }

    @NotNull
    public final ScrapeResult scrape(@NotNull ScrapeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.scrapingService.scrape(request, this.client);
    }
}

