/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Shellcheck {
    public static final String VERSION = "0.9.0";

    private Shellcheck() {
    }

    public static Result run(String runId, Path shellcheckBinary, List<String> args, List<Path> scriptsToCheck, Path capturedStdout, Path capturedStderr) throws IOException, InterruptedException {
        ArrayList<String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(shellcheckBinary.toFile().getAbsolutePath());
        commandAndArgs.addAll(args);
        commandAndArgs.addAll(scriptsToCheck.stream().map(path -> path.toFile().getAbsolutePath()).collect(Collectors.toList()));
        Process process = new ProcessBuilder(new String[0]).redirectOutput(capturedStdout.toFile()).redirectError(capturedStderr.toFile()).command(commandAndArgs).start();
        int exitCode = process.waitFor();
        return new Result(runId, Collections.unmodifiableList(commandAndArgs), exitCode, capturedStdout, capturedStderr);
    }

    public static class Result {
        public final String runId;
        public final List<String> cmdLine;
        public final int exitCode;
        public final Path stdout;
        public final Path stderr;

        public Result(String runId, List<String> cmdLine, int exitCode, Path stdout, Path stderr) {
            this.runId = runId;
            this.cmdLine = cmdLine;
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public boolean isNotOk() {
            return this.exitCode != 0;
        }
    }
}

