/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import dev.dimlight.maven.plugin.shellcheck.BinaryResolutionMethod;
import dev.dimlight.maven.plugin.shellcheck.BinaryResolver;
import dev.dimlight.maven.plugin.shellcheck.ChunkIterator;
import dev.dimlight.maven.plugin.shellcheck.PluginPaths;
import dev.dimlight.maven.plugin.shellcheck.Shellcheck;
import dev.dimlight.maven.plugin.shellcheck.SourceDir;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="check", threadSafe=false, defaultPhase=LifecyclePhase.VERIFY)
public class ShellCheckMojo
extends AbstractMojo {
    @Parameter(property="skip.shellcheck", required=true, defaultValue="false")
    private boolean skip;
    @Parameter(required=false)
    private List<SourceDir> sourceDirs;
    @Parameter(required=true, defaultValue=".sh")
    private String shellFileExtension;
    @Parameter(required=true, defaultValue="download")
    private BinaryResolutionMethod binaryResolutionMethod;
    @Parameter(required=false)
    private File externalBinaryPath;
    @Parameter(required=false)
    private Map<String, URL> releaseArchiveUrls;
    @Parameter(required=false, defaultValue="")
    private List<String> args;
    @Parameter(required=true, defaultValue="shellcheck.@executionId@.@runNumber@.stdout")
    private String capturedStdoutFileName;
    @Parameter(required=true, defaultValue="shellcheck.@executionId@.@runNumber@.stderr")
    private String capturedStderrFileName;
    @Parameter(required=false, defaultValue="false")
    private boolean splitInvocations = false;
    @Parameter(required=false)
    private int filesPerInvocation = Short.MAX_VALUE;
    @Parameter(required=true, defaultValue="false")
    private boolean failBuildIfWarnings;
    @Parameter(required=true, defaultValue="${project.build.directory}", readonly=true)
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(required=true, defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping plugin execution");
            return;
        }
        log.debug((CharSequence)("Execution id is [" + this.execution.getExecutionId() + "]"));
        PluginPaths pluginPaths = new PluginPaths(this.outputDirectory.toPath());
        try {
            BinaryResolver binaryResolver = new BinaryResolver(this.mavenProject, this.mavenSession, this.pluginManager, this.outputDirectory.toPath(), Optional.ofNullable(this.externalBinaryPath).map(File::toPath), Optional.ofNullable(this.releaseArchiveUrls).orElseGet(Collections::emptyMap), log);
            Path binary = binaryResolver.resolve(this.binaryResolutionMethod);
            ArrayList<Shellcheck.Result> runs = new ArrayList<Shellcheck.Result>();
            List<Path> allFilesCheck = this.searchFilesToBeChecked();
            Iterator<List<Path>> runIter = this.splitInvocations ? ChunkIterator.over(this.filesPerInvocation(), allFilesCheck) : Collections.singletonList(allFilesCheck).iterator();
            int runNum = 0;
            while (runIter.hasNext()) {
                List<Path> scriptsToCheck = runIter.next();
                String runId = this.execution.getExecutionId() + "." + runNum;
                long startTime = System.currentTimeMillis();
                log.debug((CharSequence)("Running shellcheck [" + runId + "] on [" + scriptsToCheck.size() + "] files"));
                Shellcheck.Result result = Shellcheck.run(runId, binary, Optional.ofNullable(this.args).orElseGet(Collections::emptyList), scriptsToCheck, pluginPaths.getPathInPluginOutputDirectory(this.renderTemplatedFilename(this.capturedStdoutFileName, this.execution, runNum)), pluginPaths.getPathInPluginOutputDirectory(this.renderTemplatedFilename(this.capturedStderrFileName, this.execution, runNum)));
                long elapsed = System.currentTimeMillis() - startTime;
                log.debug((CharSequence)("Shellcheck run [" + result.runId + "] on [" + scriptsToCheck.size() + "] files took [" + elapsed + "] millis"));
                runs.add(result);
                ++runNum;
            }
            List failures = runs.stream().filter(Shellcheck.Result::isNotOk).collect(Collectors.toList());
            if (!failures.isEmpty()) {
                for (Shellcheck.Result failedRun : failures) {
                    log.warn((CharSequence)("------ Shellcheck run [" + failedRun.runId + "] returned [" + failedRun.exitCode + "] stdout will follow -----------------------------------------"));
                    Files.readAllLines(failedRun.stdout).forEach(arg_0 -> ((Log)log).warn(arg_0));
                    log.warn((CharSequence)("------ Shellcheck run [" + failedRun.runId + "] returned [" + failedRun.exitCode + "] stderr will follow -----------------------------------------"));
                    Files.readAllLines(failedRun.stderr).forEach(arg_0 -> ((Log)log).error(arg_0));
                }
                if (this.failBuildIfWarnings) {
                    throw new MojoExecutionException("There are shellcheck problems: [" + failures.size() + "]/[" + runs.size() + "] shellcheck runs had non-zero exit codes");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private int filesPerInvocation() {
        return this.filesPerInvocation <= 0 ? Integer.MAX_VALUE : this.filesPerInvocation;
    }

    private SourceDir defaultSourceDir() {
        File srcMainSh = Paths.get(this.baseDir.getAbsolutePath(), "src", "main", "sh").toFile();
        SourceDir sourceDir = new SourceDir();
        sourceDir.setDirectory(srcMainSh.getAbsolutePath());
        sourceDir.addInclude("**/*.sh");
        return sourceDir;
    }

    private List<Path> searchFilesToBeChecked() {
        Log log = this.getLog();
        FileSetManager fileSetManager = new FileSetManager(log, true);
        ArrayList<Path> filesToCheck = new ArrayList<Path>();
        List<SourceDir> sourceDirs = Optional.ofNullable(this.sourceDirs).orElse(Collections.singletonList(this.defaultSourceDir()));
        for (SourceDir sourceDir : sourceDirs) {
            List includedFiles = Arrays.stream(fileSetManager.getIncludedFiles((FileSet)sourceDir)).map(includedFile -> Paths.get(sourceDir.getDirectory(), includedFile)).peek(includedPath -> log.debug((CharSequence)("Shellcheck will check file: [" + includedPath.toFile().getAbsolutePath() + "]"))).collect(Collectors.toList());
            filesToCheck.addAll(includedFiles);
        }
        filesToCheck.sort(Comparator.comparing(path -> path.toAbsolutePath().toString()));
        return filesToCheck;
    }

    private String renderTemplatedFilename(String fileName, MojoExecution execution, int runNumber) {
        return fileName.replace("@executionId@", execution.getExecutionId()).replace("@runNumber@", Integer.toString(runNumber));
    }
}

