/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We know what we're doing")
public class ChunkIterator<T>
implements Iterator<List<T>> {
    private final Iterator<T> iterator;
    private final int chunkSize;

    private ChunkIterator(int chunkSize, Iterator<T> iter) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive: [" + chunkSize + "]");
        }
        this.chunkSize = chunkSize;
        this.iterator = iter;
    }

    public static <T> Iterator<List<T>> over(int chunkSize, Iterable<T> iterable) {
        return new ChunkIterator<T>(chunkSize, iterable.iterator());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> next() {
        ArrayList<T> out;
        ArrayList<Object> arrayList = out = this.chunkSize < 2048 ? new ArrayList<T>(this.chunkSize) : new ArrayList();
        for (int currentChunkSize = 0; this.iterator.hasNext() && currentChunkSize < this.chunkSize; ++currentChunkSize) {
            out.add(this.iterator.next());
        }
        return out;
    }
}

