/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Shellcheck {
    public static final String VERSION = "0.8.0";

    private Shellcheck() {
    }

    public static Result run(Path shellcheckBinary, List<String> args, Path outdir, List<Path> scriptsToCheck) throws IOException, InterruptedException {
        String pluginOutDirAbsPath = outdir.toFile().getAbsolutePath();
        ArrayList<String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(shellcheckBinary.toFile().getAbsolutePath());
        commandAndArgs.addAll(args);
        commandAndArgs.addAll(scriptsToCheck.stream().map(path -> path.toFile().getAbsolutePath()).collect(Collectors.toList()));
        Path stdout = Paths.get(pluginOutDirAbsPath, "shellcheck.stdout");
        Path stderr = Paths.get(pluginOutDirAbsPath, "shellcheck.stderr");
        Process process = new ProcessBuilder(new String[0]).redirectOutput(stdout.toFile()).redirectError(stderr.toFile()).command(commandAndArgs).start();
        int exitCode = process.waitFor();
        return new Result(exitCode, stdout, stderr);
    }

    public static class Result {
        public final int exitCode;
        public final Path stdout;
        public final Path stderr;

        public Result(int exitCode, Path stdout, Path stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public boolean isNotOk() {
            return this.exitCode != 0;
        }
    }
}

