/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import dev.dimlight.maven.plugin.shellcheck.BinaryResolutionMethod;
import dev.dimlight.maven.plugin.shellcheck.BinaryResolver;
import dev.dimlight.maven.plugin.shellcheck.PluginPaths;
import dev.dimlight.maven.plugin.shellcheck.Shellcheck;
import dev.dimlight.maven.plugin.shellcheck.SourceDir;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
public class ShellCheckMojo
extends AbstractMojo {
    @Parameter(property="skip.shellcheck", required=true, defaultValue="false", readonly=true)
    private boolean skip;
    @Parameter(required=false, readonly=true)
    private List<SourceDir> sourceDirs;
    @Parameter(required=true, defaultValue=".sh", readonly=true)
    private String shellFileExtension;
    @Parameter(required=true, readonly=true, defaultValue="download")
    private BinaryResolutionMethod binaryResolutionMethod;
    @Parameter(required=false, readonly=true)
    private File externalBinaryPath;
    @Parameter(required=false, readonly=true)
    private Map<String, URL> releaseArchiveUrls;
    @Parameter(required=false, readonly=true, defaultValue="")
    private List<String> args;
    @Parameter(required=true, defaultValue="false")
    private boolean failBuildIfWarnings;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping plugin execution");
            return;
        }
        PluginPaths pluginPaths = new PluginPaths(this.outputDirectory.toPath());
        try {
            List<Path> scriptsToCheck = this.searchFilesToBeChecked();
            BinaryResolver binaryResolver = new BinaryResolver(this.mavenProject, this.mavenSession, this.pluginManager, this.outputDirectory.toPath(), Optional.ofNullable(this.externalBinaryPath).map(File::toPath), Optional.ofNullable(this.releaseArchiveUrls).orElseGet(Collections::emptyMap), log);
            Path binary = binaryResolver.resolve(this.binaryResolutionMethod);
            Shellcheck.Result result = Shellcheck.run(binary, Optional.ofNullable(this.args).orElseGet(Collections::emptyList), pluginPaths.getPluginOutputDirectory(), scriptsToCheck);
            Files.readAllLines(result.stdout).forEach(arg_0 -> ((Log)log).warn(arg_0));
            Files.readAllLines(result.stderr).forEach(arg_0 -> ((Log)log).error(arg_0));
            if (result.isNotOk() && this.failBuildIfWarnings) {
                throw new MojoExecutionException("There are shellcheck problems: shellcheck exit code [" + result.exitCode + "]");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private SourceDir defaultSourceDir() {
        File srcMainSh = Paths.get(this.baseDir.getAbsolutePath(), "src", "main", "sh").toFile();
        SourceDir sourceDir = new SourceDir();
        sourceDir.setDirectory(srcMainSh.getAbsolutePath());
        sourceDir.addInclude("**/*.sh");
        return sourceDir;
    }

    private List<Path> searchFilesToBeChecked() throws MojoExecutionException {
        Log log = this.getLog();
        FileSetManager fileSetManager = new FileSetManager(log, true);
        ArrayList<Path> filesToCheck = new ArrayList<Path>();
        List<SourceDir> sourceDirs = Optional.ofNullable(this.sourceDirs).orElse(Collections.singletonList(this.defaultSourceDir()));
        for (SourceDir sourceDir : sourceDirs) {
            List includedFiles = Arrays.stream(fileSetManager.getIncludedFiles((FileSet)sourceDir)).map(includedFile -> Paths.get(sourceDir.getDirectory(), includedFile)).peek(includedPath -> log.debug((CharSequence)("Shellcheck will check file: [" + includedPath.toFile().getAbsolutePath() + "]"))).collect(Collectors.toList());
            filesToCheck.addAll(includedFiles);
        }
        return filesToCheck;
    }
}

