/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import dev.dimlight.maven.plugin.shellcheck.Architecture;
import dev.dimlight.maven.plugin.shellcheck.BinaryResolutionMethod;
import dev.dimlight.maven.plugin.shellcheck.PluginPaths;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class BinaryResolver {
    private final Log log;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final BuildPluginManager pluginManager;
    private final Optional<Path> externalBinaryPath;
    private final Architecture arch;
    private final PluginPaths pluginPaths;
    private final Map<String, URL> releaseArchiveUrls;

    public BinaryResolver(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, Path mavenTargetDirectory, Optional<Path> externalBinaryPath, Map<String, URL> releaseArchiveUrl, Log log) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.releaseArchiveUrls = releaseArchiveUrl;
        this.externalBinaryPath = externalBinaryPath;
        this.log = log;
        this.arch = Architecture.detect();
        log.info((CharSequence)("os arch: [" + Architecture.osArchKey() + "]"));
        this.pluginPaths = new PluginPaths(mavenTargetDirectory);
    }

    public Path resolve(BinaryResolutionMethod resolutionMethod) throws MojoExecutionException, IOException {
        switch (resolutionMethod) {
            case external: {
                return this.validateBinaryPath(this.externalBinaryPath, BinaryResolutionMethod.external);
            }
            case download: {
                return this.downloadShellcheckBinaryAndGuessBinary();
            }
            case embedded: {
                return this.extractEmbeddedShellcheckBinary();
            }
        }
        throw new IllegalStateException("Invalid resolution method: " + (Object)((Object)resolutionMethod));
    }

    private Path validateBinaryPath(Optional<Path> binaryPath, BinaryResolutionMethod binaryOrigin) throws MojoExecutionException {
        return binaryPath.map(Path::toFile).filter(File::exists).filter(File::canRead).filter(file -> !this.arch.isUnixLike() || file.canExecute()).map(File::toPath).orElseThrow(() -> new MojoExecutionException("The " + binaryOrigin.name() + " shellcheck binary has not been provided or cannot be found or is not readable/ executable"));
    }

    private Path validateBinaryPath(Path binaryPath, BinaryResolutionMethod binaryOrigin) throws MojoExecutionException {
        return this.validateBinaryPath(Optional.ofNullable(binaryPath), binaryOrigin);
    }

    private Path downloadShellcheckBinaryAndGuessBinary() throws MojoExecutionException, IOException {
        URL u = this.releaseArchiveUrls.get(Architecture.osArchKey());
        if (u == null) {
            this.log.warn((CharSequence)("No shellcheck download url provided for current os.name-os.arch [" + Architecture.osArchKey() + "]"));
            u = this.arch.downloadUrl();
        }
        String url = u.toExternalForm();
        this.log.info((CharSequence)("shellcheck release will be fetched at [" + url + "]"));
        Path downloadAndUnpackPath = this.pluginPaths.getPluginOutputDirectory();
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.googlecode.maven-download-plugin"), (String)MojoExecutor.artifactId((String)"download-maven-plugin"), (String)MojoExecutor.version((String)"1.6.0")), (String)MojoExecutor.goal((String)"wget"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"uri"), (String)url), MojoExecutor.element((String)MojoExecutor.name((String)"unpack"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)downloadAndUnpackPath.toFile().getAbsolutePath())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        Path expectedDownloadedBinary = BinaryResolver.guessUnpackedBinary(downloadAndUnpackPath, this.arch);
        this.arch.makeExecutable(expectedDownloadedBinary);
        return this.validateBinaryPath(expectedDownloadedBinary, BinaryResolutionMethod.download);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Path extractEmbeddedShellcheckBinary() throws IOException, MojoExecutionException {
        this.log.debug((CharSequence)("Detected arch is [" + (Object)((Object)this.arch) + "]"));
        String binaryTargetName = "shellcheck" + this.arch.idiomaticExecutableSuffix();
        Path binaryPath = this.pluginPaths.getPathInPluginOutputDirectory(binaryTargetName);
        boolean created = binaryPath.toFile().mkdirs();
        this.log.debug((CharSequence)("Path [" + binaryPath + "] was created? [" + created + "]"));
        String binResourcePath = this.arch.embeddedBinPath();
        this.log.debug((CharSequence)("Will try to use binary [" + binResourcePath + "]"));
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(binResourcePath);){
            if (resourceAsStream == null) {
                throw new MojoExecutionException("No embedded binary found for shellcheck");
            }
            Files.copy(resourceAsStream, binaryPath, StandardCopyOption.REPLACE_EXISTING);
        }
        this.arch.makeExecutable(binaryPath);
        return this.validateBinaryPath(binaryPath, BinaryResolutionMethod.embedded);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public static Path guessUnpackedBinary(Path fromPath, Architecture arch) throws IOException {
        try (Stream<Path> paths = Files.walk(fromPath, new FileVisitOption[0]);){
            List canditates = paths.map(Path::toFile).filter(File::isFile).filter(file -> file.getName().equals("shellcheck" + arch.idiomaticExecutableSuffix())).collect(Collectors.toList());
            if (canditates.size() > 1) {
                throw new FileNotFoundException("There are multiple binaries candidate in the unpacked shellcheck release: [" + canditates + "] at [" + fromPath + "]");
            }
            if (canditates.isEmpty()) {
                throw new FileNotFoundException("No binary candidates found in the unpacked shellcheck release at [" + fromPath + "]");
            }
            Path path = ((File)canditates.iterator().next()).toPath();
            return path;
        }
    }
}

