/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import dev.dimlight.maven.plugin.shellcheck.BinaryResolutionMethod;
import dev.dimlight.maven.plugin.shellcheck.BinaryResolver;
import dev.dimlight.maven.plugin.shellcheck.PluginPaths;
import dev.dimlight.maven.plugin.shellcheck.Shellcheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
public class ShellCheckMojo
extends AbstractMojo {
    @Parameter(required=false, readonly=true)
    private List<File> sourceLocations;
    @Parameter(required=true, readonly=true, defaultValue="download")
    private BinaryResolutionMethod binaryResolutionMethod;
    @Parameter(required=false, readonly=true)
    private File externalBinaryPath;
    @Parameter(required=false, readonly=true)
    private Map<String, URL> releaseArchiveUrls;
    @Parameter(required=true, defaultValue=".sh", readonly=true)
    private String shellFileExtension;
    @Parameter(required=true, defaultValue="false")
    private boolean failBuildIfWarnings;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        PluginPaths pluginPaths = new PluginPaths(this.outputDirectory.toPath());
        try {
            List<Path> scriptsToCheck = this.searchFilesToBeChecked();
            BinaryResolver binaryResolver = new BinaryResolver(this.mavenProject, this.mavenSession, this.pluginManager, this.outputDirectory.toPath(), Optional.ofNullable(this.externalBinaryPath).map(File::toPath), Optional.ofNullable(this.releaseArchiveUrls).orElse(Collections.emptyMap()), log);
            Path binary = binaryResolver.resolve(this.binaryResolutionMethod);
            Shellcheck.Result result = Shellcheck.run(binary, pluginPaths.getPluginOutputDirectory(), scriptsToCheck);
            Files.readAllLines(result.stdout).forEach(arg_0 -> ((Log)log).warn(arg_0));
            Files.readAllLines(result.stderr).forEach(arg_0 -> ((Log)log).error(arg_0));
            if (result.isNotOk() && this.failBuildIfWarnings) {
                throw new MojoExecutionException("There are shellcheck problems: shellcheck exit code [" + result.exitCode + "]");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private List<File> sourceLocations() {
        File srcMainSh = Paths.get(this.baseDir.getAbsolutePath(), "src", "main", "sh").toFile();
        return this.sourceLocations == null ? Collections.singletonList(srcMainSh) : this.sourceLocations;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private List<Path> searchFilesToBeChecked() throws IOException {
        ArrayList<Path> foundFiles = new ArrayList<Path>();
        for (File sourceLocation : this.sourceLocations()) {
            if (sourceLocation.isFile()) {
                foundFiles.add(sourceLocation.toPath());
                continue;
            }
            if (sourceLocation.isDirectory()) {
                Stream<Path> paths = Files.walk(Paths.get(sourceLocation.getAbsolutePath(), new String[0]), new FileVisitOption[0]);
                try {
                    foundFiles.addAll(paths.filter(path -> path.toFile().isFile()).filter(path -> path.toFile().getName().endsWith(this.shellFileExtension)).collect(Collectors.toList()));
                    continue;
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                    continue;
                }
            }
            this.getLog().warn((CharSequence)("Skipped shellcheck source location [" + sourceLocation + "]"));
        }
        return foundFiles;
    }
}

