/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import dev.dimlight.maven.plugin.shellcheck.Architecture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginPaths {
    private final Path pluginOutputDirectory;

    public PluginPaths(Path mavenTargetDirectory) {
        this.pluginOutputDirectory = Paths.get(mavenTargetDirectory.toFile().getAbsolutePath(), "shellcheck-plugin");
    }

    public Path getPluginOutputDirectory() {
        return this.pluginOutputDirectory;
    }

    public Path getPathInPluginOutputDirectory(String ... pathFragments) {
        return Paths.get(this.pluginOutputDirectory.toFile().getAbsolutePath(), pathFragments);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Path guessUnpackedBinary(Path fromPath, Architecture arch) throws IOException {
        try (Stream<Path> paths = Files.walk(fromPath, new FileVisitOption[0]);){
            List canditates = paths.map(Path::toFile).filter(File::isFile).filter(file -> file.getName().equals("shellcheck" + arch.idiomaticExecutableSuffix())).collect(Collectors.toList());
            if (canditates.size() > 1) {
                throw new FileNotFoundException("There are multiple binaries candidate in the unpacked shellcheck release: [" + canditates + "] at [" + fromPath + "]");
            }
            if (canditates.isEmpty()) {
                throw new FileNotFoundException("No binary candidates found in the unpacked shellcheck release at [" + fromPath + "]");
            }
            Path path = ((File)canditates.iterator().next()).toPath();
            return path;
        }
    }
}

