/*
 * Decompiled with CFR 0.152.
 */
package dev.dimlight.maven.plugin.shellcheck;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;

public enum Architecture {
    Linux_x86_64,
    Linux_armv6hf,
    Linux_aarch64,
    macOS_x86_64,
    Windows_x86,
    unsupported;


    public static String osArchKey() {
        return (System.getProperty("os.name") + "-" + System.getProperty("os.arch")).replace(" ", "_");
    }

    public static Architecture detect() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch");
        if (osName.contains("win")) {
            if (osArch.contains("amd64") || osArch.contains("x86")) {
                return Windows_x86;
            }
        } else {
            if (osName.contains("mac")) {
                return macOS_x86_64;
            }
            if (osName.contains("nux")) {
                switch (osArch) {
                    case "amd64": {
                        return Linux_x86_64;
                    }
                    case "aarch64": {
                        return Linux_aarch64;
                    }
                    case "arm": {
                        return Linux_armv6hf;
                    }
                }
            }
        }
        return unsupported;
    }

    public String embeddedBinPath() {
        if (this.equals((Object)unsupported)) {
            throw new UnsupportedOperationException(Architecture.notSupportedMessage("No embedded shellcheck binaries for this architecture."));
        }
        if (this.equals((Object)Windows_x86)) {
            return String.format("/shellcheck-bin/%s/shellcheck-v%s.exe", this.name(), "0.7.1");
        }
        return String.format("/shellcheck-bin/%s/shellcheck-v%s/shellcheck", this.name(), "0.7.1");
    }

    public boolean isUnixLike() {
        return !this.equals((Object)Windows_x86);
    }

    public URL downloadUrl() {
        String url;
        switch (this) {
            case Linux_x86_64: {
                url = String.format("https://github.com/koalaman/shellcheck/releases/download/v%s/shellcheck-v%s.linux.x86_64.tar.xz", "0.7.1", "0.7.1");
                break;
            }
            case Linux_armv6hf: {
                url = String.format("https://github.com/koalaman/shellcheck/releases/download/v$%s/shellcheck-v%s.linux.armv6hf.tar.xz", "0.7.1", "0.7.1");
                break;
            }
            case Linux_aarch64: {
                url = String.format("https://github.com/koalaman/shellcheck/releases/download/v%s/shellcheck-v%s.linux.aarch64.tar.xz", "0.7.1", "0.7.1");
                break;
            }
            case macOS_x86_64: {
                url = String.format("https://github.com/koalaman/shellcheck/releases/download/v%s/shellcheck-v%s.darwin.x86_64.tar.xz", "0.7.1", "0.7.1");
                break;
            }
            case Windows_x86: {
                url = String.format("https://github.com/koalaman/shellcheck/releases/download/v%s/shellcheck-v%s.zip", "0.7.1", "0.7.1");
                break;
            }
            default: {
                throw new UnsupportedOperationException(Architecture.notSupportedMessage("No shellcheck binary for this architecture"));
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void makeExecutable(Path path) throws IOException {
        switch (this) {
            case unsupported: {
                throw new UnsupportedOperationException(Architecture.notSupportedMessage("No support for this architecture."));
            }
            case Linux_x86_64: 
            case Linux_armv6hf: 
            case Linux_aarch64: 
            case macOS_x86_64: {
                String perm755 = "rwxr-xr-x";
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxr-xr-x"));
                break;
            }
        }
    }

    public String idiomaticExecutableSuffix() {
        if (this.equals((Object)Windows_x86)) {
            return ".exe";
        }
        return "";
    }

    public static String notSupportedMessage(String prefix) {
        return prefix + " os.name [" + System.getProperty("os.name") + "] os.arch [" + System.getProperty("os.arch") + "]";
    }
}

