/*
 * Decompiled with CFR 0.152.
 */
package dev.dhruv.javaannotate.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.dhruv.javaannotate.annotations.Field;
import dev.dhruv.javaannotate.annotations.Fields;
import dev.dhruv.javaannotate.annotations.Model;
import dev.dhruv.javaannotate.annotations.Models;
import dev.dhruv.javaannotate.annotations.RenameField;
import dev.dhruv.javaannotate.models.FieldModel;
import dev.dhruv.javaannotate.models.ModelsMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"dev.dhruv.javaannotate.annotations.Models"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class ModelProcessor
extends AbstractProcessor {
    private Elements elements;
    private boolean isAllFieldConstructorCreated = false;
    private Filer filer;
    private Messager messager;
    private boolean isEmptyConstructorCreated = false;
    private Types types;
    private TypeSpec.Builder replicatedClassBuilder;
    private Map<String, FieldModel> replicatedClassFieldsMap;
    private List<FieldSpec> builderFieldSpecs = new ArrayList<FieldSpec>();

    private void createAllFieldConstructor() {
        this.isAllFieldConstructorCreated = true;
        MethodSpec.Builder getterMethodSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (FieldModel fieldModel : this.replicatedClassFieldsMap.values()) {
            if (fieldModel.isFinal()) continue;
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)fieldModel.getTypeName(), (String)fieldModel.getFieldName(), (Modifier[])new Modifier[0]).build();
            getterMethodSpec.addParameter(parameterSpec);
            getterMethodSpec.addStatement("this." + fieldModel.getFieldName() + "=" + fieldModel.getFieldName(), new Object[0]);
        }
        this.replicatedClassBuilder.addMethod(getterMethodSpec.build());
    }

    private void createBuilder(Model replicatedClassModel) {
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        MethodSpec constuctor = MethodSpec.methodBuilder((String)"Builder").returns((TypeName)ClassName.bestGuess((String)"Builder")).addStatement("return new Builder()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        MethodSpec buildMethod = MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.bestGuess((String)replicatedClassModel.value())).addStatement("return new " + replicatedClassModel.value() + "(this)", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        this.replicatedClassBuilder.addMethod(constuctor);
        typeSpec.addMethod(buildMethod);
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        for (FieldSpec builderFieldSpec : this.builderFieldSpecs) {
            typeSpec.addField(builderFieldSpec);
            codeBlock.add("this." + builderFieldSpec.name + "=" + builderFieldSpec.name + ";", new Object[0]);
            MethodSpec builderAddFieldMethod = MethodSpec.methodBuilder((String)builderFieldSpec.name).returns((TypeName)ClassName.bestGuess((String)"Builder")).addParameter(builderFieldSpec.type, builderFieldSpec.name, new Modifier[0]).addStatement("this." + builderFieldSpec.name + "=" + builderFieldSpec.name, new Object[0]).addStatement("return this", new Object[0]).build();
            typeSpec.addMethod(builderAddFieldMethod);
        }
        MethodSpec initBuilderMethod = MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.bestGuess((String)"Builder"), "Builder", new Modifier[0]).addCode(codeBlock.build()).build();
        this.replicatedClassBuilder.addMethod(initBuilderMethod);
        this.replicatedClassBuilder.addType(typeSpec.build());
    }

    private void createClassElements(Model replicatedClassModel) {
        if (replicatedClassModel.emptyConstructor()) {
            this.createEmptyConstructor();
        }
        if (replicatedClassModel.allArgConstructor()) {
            this.createAllFieldConstructor();
        }
        if (replicatedClassModel.singleton()) {
            this.createSingleton(replicatedClassModel);
        }
        if (replicatedClassModel.builder()) {
            this.createBuilder(replicatedClassModel);
        }
    }

    private void createClasses(List<ModelsMap> modelsMaps) {
        for (ModelsMap modelsMap : modelsMaps) {
            for (Model replicatedClassModel : modelsMap.getReplicatedClasses()) {
                this.replicatedClassFieldsMap = new HashMap<String, FieldModel>();
                this.isEmptyConstructorCreated = false;
                this.isAllFieldConstructorCreated = false;
                this.replicatedClassBuilder = TypeSpec.classBuilder((String)replicatedClassModel.value()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                List<VariableElement> originalFields = ElementFilter.fieldsIn(modelsMap.getMainClass().getEnclosedElements());
                for (VariableElement originalField : originalFields) {
                    boolean createGetter = replicatedClassModel.getters();
                    boolean createSetter = replicatedClassModel.setters();
                    String fieldName = originalField.getSimpleName().toString();
                    if (originalField.getAnnotation(RenameField.class) != null) {
                        RenameField renameField = originalField.getAnnotation(RenameField.class);
                        if (renameField != null && !renameField.value().isEmpty()) {
                            fieldName = renameField.value();
                        }
                    } else if (originalField.getAnnotation(Fields.class) != null) {
                        Field[] replicatedFieldsConfig;
                        for (Field replicatedField : replicatedFieldsConfig = originalField.getAnnotation(Fields.class).value()) {
                            if (!replicatedField.value().equalsIgnoreCase(replicatedClassModel.value())) continue;
                            fieldName = replicatedField.renameTo();
                            createGetter = replicatedField.getter();
                            createSetter = replicatedField.setter();
                        }
                    }
                    this.createElements(originalField, fieldName, createSetter, createGetter);
                }
                this.createClassElements(replicatedClassModel);
                try {
                    JavaFile.builder((String)modelsMap.getPackageName(), (TypeSpec)this.replicatedClassBuilder.build()).build().writeTo(this.filer);
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Error creating replicated class, " + e.getMessage());
                }
            }
        }
    }

    private void createElements(VariableElement originalField, String fieldName, boolean createSetter, boolean createGetter) {
        this.createField(originalField, fieldName);
        String capitalizeFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (createSetter) {
            this.createSetter(originalField, fieldName, capitalizeFieldName);
        }
        if (createGetter) {
            this.createGetter(originalField, fieldName, capitalizeFieldName);
        }
        FieldModel fieldModel = new FieldModel(TypeName.get((TypeMirror)originalField.asType()), fieldName, originalField.getModifiers().contains((Object)Modifier.FINAL));
        this.replicatedClassFieldsMap.put(fieldName, fieldModel);
    }

    private void createEmptyConstructor() {
        this.isEmptyConstructorCreated = true;
        MethodSpec getterMethodSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        this.replicatedClassBuilder.addMethod(getterMethodSpec);
    }

    private void createField(VariableElement originalField, String fieldName) {
        FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)originalField.asType()), (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(originalField.getModifiers().toArray(new Modifier[originalField.getModifiers().size()]));
        Object value = null;
        if (originalField.getConstantValue() != null && originalField.getModifiers().contains((Object)Modifier.FINAL)) {
            value = originalField.getConstantValue();
            if (value instanceof String) {
                fieldSpec.initializer("$S", new Object[]{value});
            } else if (value instanceof Long) {
                fieldSpec.initializer("$LL", new Object[]{value});
            } else {
                fieldSpec.initializer("$L", new Object[]{value});
            }
        }
        this.replicatedClassBuilder.addField(fieldSpec.build());
        this.builderFieldSpecs.add(fieldSpec.build());
    }

    private void createGetter(VariableElement field, String fieldName, String capitalizeFieldName) {
        CodeBlock getterCode = CodeBlock.builder().addStatement("return " + fieldName, new Object[0]).build();
        MethodSpec getterMethodSpec = MethodSpec.methodBuilder((String)("get" + capitalizeFieldName)).addCode(getterCode).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)field.asType())).build();
        this.replicatedClassBuilder.addMethod(getterMethodSpec);
    }

    private void createSetter(VariableElement field, String fieldName, String capitalizeFieldName) {
        if (!field.getModifiers().contains((Object)Modifier.FINAL)) {
            CodeBlock setterCode = CodeBlock.builder().addStatement("this." + fieldName + "=" + fieldName, new Object[0]).build();
            MethodSpec setterMethodSpec = MethodSpec.methodBuilder((String)("set" + capitalizeFieldName)).addCode(setterCode).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)field.asType()), fieldName, new Modifier[0]).returns(Void.TYPE).build();
            this.replicatedClassBuilder.addMethod(setterMethodSpec);
        }
    }

    private void createSingleton(Model replicatedClassModel) {
        String className = replicatedClassModel.value();
        FieldSpec sInstanceField = FieldSpec.builder((TypeName)ClassName.bestGuess((String)className), (String)"sInstance", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
        this.replicatedClassBuilder.addField(sInstanceField);
        CodeBlock codeBlock = CodeBlock.builder().beginControlFlow("if(sInstance == null)", new Object[0]).addStatement(String.format("sInstance = new %s()", className), new Object[0]).endControlFlow().addStatement("return sInstance", new Object[0]).build();
        MethodSpec getInstanceMethod = MethodSpec.methodBuilder((String)"getInstance").returns((TypeName)ClassName.bestGuess((String)className)).addCode(codeBlock).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        this.replicatedClassBuilder.addMethod(getInstanceMethod);
        if (!this.isEmptyConstructorCreated) {
            this.createEmptyConstructor();
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<ModelsMap> modelsMaps = new ArrayList<ModelsMap>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Models.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Can be applied to class.");
                return true;
            }
            ArrayList<Model> classNames = new ArrayList<Model>(Arrays.asList(element.getAnnotation(Models.class).value()));
            TypeElement typeElement = (TypeElement)element;
            String packageName = this.elements.getPackageOf(typeElement).getQualifiedName().toString();
            ModelsMap modelsMap = new ModelsMap();
            modelsMap.setMainClass(typeElement);
            modelsMap.setReplicatedClasses(classNames);
            modelsMap.setPackageName(packageName);
            modelsMaps.add(modelsMap);
        }
        this.createClasses(modelsMaps);
        return false;
    }
}

