/*
 * Decompiled with CFR 0.152.
 */
package dev.dhruv.javaannotate.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.dhruv.javaannotate.annotations.Field;
import dev.dhruv.javaannotate.annotations.Fields;
import dev.dhruv.javaannotate.annotations.Model;
import dev.dhruv.javaannotate.annotations.Models;
import dev.dhruv.javaannotate.annotations.RenameField;
import dev.dhruv.javaannotate.core.clazz.BuilderCreator;
import dev.dhruv.javaannotate.core.clazz.ClassCreator;
import dev.dhruv.javaannotate.core.clazz.SingletonCreator;
import dev.dhruv.javaannotate.core.field.FieldCreator;
import dev.dhruv.javaannotate.core.method.AllFieldConstructorCreator;
import dev.dhruv.javaannotate.core.method.EmptyConstructorCreator;
import dev.dhruv.javaannotate.core.method.GetterCreator;
import dev.dhruv.javaannotate.core.method.MethodCreator;
import dev.dhruv.javaannotate.core.method.SetterCreator;
import dev.dhruv.javaannotate.models.FieldModel;
import dev.dhruv.javaannotate.models.ModelsMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"dev.dhruv.javaannotate.annotations.Models"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class ModelProcessor
extends AbstractProcessor {
    private MethodCreator methodCreator;
    private ClassCreator classCreator;
    private FieldCreator fieldCreator;
    private Elements elements;
    private Filer filer;
    private Messager messager;
    private TypeSpec.Builder replicatedClassBuilder;
    private Map<String, FieldModel> replicatedClassFieldsMap;

    private void createClassElements(Model replicatedClassModel) {
        if (replicatedClassModel.emptyConstructor()) {
            this.methodCreator = new EmptyConstructorCreator();
            this.replicatedClassBuilder.addMethod(this.methodCreator.create());
        }
        if (replicatedClassModel.allArgConstructor()) {
            this.methodCreator = new AllFieldConstructorCreator(this.replicatedClassFieldsMap.values());
            this.replicatedClassBuilder.addMethod(this.methodCreator.create());
        }
        if (replicatedClassModel.singleton()) {
            this.classCreator = new SingletonCreator(this.replicatedClassBuilder);
            this.replicatedClassBuilder = this.classCreator.create();
        }
        if (replicatedClassModel.builder()) {
            this.classCreator = new BuilderCreator(this.replicatedClassBuilder);
            this.replicatedClassBuilder = this.classCreator.create();
        }
    }

    private void createClasses(List<ModelsMap> modelsMaps) {
        for (ModelsMap modelsMap : modelsMaps) {
            for (Model replicatedClassModel : modelsMap.getReplicatedClasses()) {
                this.replicatedClassFieldsMap = new HashMap<String, FieldModel>();
                this.replicatedClassBuilder = TypeSpec.classBuilder((String)replicatedClassModel.value()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                List<VariableElement> originalFields = ElementFilter.fieldsIn(modelsMap.getMainClass().getEnclosedElements());
                for (VariableElement originalField : originalFields) {
                    boolean createGetter = replicatedClassModel.getters();
                    boolean createSetter = replicatedClassModel.setters();
                    String fieldName = originalField.getSimpleName().toString();
                    if (originalField.getAnnotation(RenameField.class) != null) {
                        RenameField renameField = originalField.getAnnotation(RenameField.class);
                        if (renameField != null && !renameField.value().isEmpty()) {
                            fieldName = renameField.value();
                        }
                    } else if (originalField.getAnnotation(Fields.class) != null) {
                        Field[] replicatedFieldsConfig;
                        for (Field replicatedField : replicatedFieldsConfig = originalField.getAnnotation(Fields.class).value()) {
                            if (!replicatedField.value().equalsIgnoreCase(replicatedClassModel.value())) continue;
                            fieldName = replicatedField.renameTo();
                            createGetter = replicatedField.getter();
                            createSetter = replicatedField.setter();
                        }
                    }
                    this.createElements(originalField, fieldName, createSetter, createGetter);
                }
                this.createClassElements(replicatedClassModel);
                try {
                    JavaFile.builder((String)modelsMap.getPackageName(), (TypeSpec)this.replicatedClassBuilder.build()).build().writeTo(this.filer);
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Error creating replicated class, " + e.getMessage());
                }
            }
        }
    }

    private void createElements(VariableElement originalField, String fieldName, boolean createSetter, boolean createGetter) {
        boolean isFinal = originalField.getModifiers().contains((Object)Modifier.FINAL);
        this.fieldCreator = new FieldCreator(originalField, fieldName);
        this.replicatedClassBuilder.addField(this.fieldCreator.create());
        if (createSetter && !isFinal) {
            this.methodCreator = new SetterCreator(originalField, fieldName);
            this.replicatedClassBuilder.addMethod(this.methodCreator.create());
        }
        if (createGetter) {
            this.methodCreator = new GetterCreator(originalField, fieldName);
            this.replicatedClassBuilder.addMethod(this.methodCreator.create());
        }
        FieldModel fieldModel = new FieldModel(TypeName.get((TypeMirror)originalField.asType()), fieldName, originalField.getModifiers().contains((Object)Modifier.FINAL));
        this.replicatedClassFieldsMap.put(fieldName, fieldModel);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<ModelsMap> modelsMaps = new ArrayList<ModelsMap>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Models.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Can be applied to class.");
                return true;
            }
            ArrayList<Model> classNames = new ArrayList<Model>(Arrays.asList(element.getAnnotation(Models.class).value()));
            TypeElement typeElement = (TypeElement)element;
            String packageName = this.elements.getPackageOf(typeElement).getQualifiedName().toString();
            ModelsMap modelsMap = new ModelsMap();
            modelsMap.setMainClass(typeElement);
            modelsMap.setReplicatedClasses(classNames);
            modelsMap.setPackageName(packageName);
            modelsMaps.add(modelsMap);
        }
        this.createClasses(modelsMaps);
        return false;
    }
}

