/*
 * Decompiled with CFR 0.152.
 */
package dev.dhruv.javaannotate.core.clazz;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.dhruv.javaannotate.core.clazz.ClassCreator;
import dev.dhruv.javaannotate.core.method.EmptyConstructorCreator;
import javax.lang.model.element.Modifier;

public class SingletonCreator
extends ClassCreator {
    public static final String S_INSTANCE = "sInstance";

    public SingletonCreator(TypeSpec.Builder clazzBuilder) {
        super(clazzBuilder);
    }

    @Override
    public TypeSpec.Builder create() {
        this.createInstanceField();
        this.createGetInstanceMethod();
        if (!this.isEmptyConstructorCreated()) {
            MethodSpec constructor = new EmptyConstructorCreator().create();
            this.clazzBuilder.addMethod(constructor);
        }
        return this.clazzBuilder;
    }

    private void createGetInstanceMethod() {
        CodeBlock codeBlock = CodeBlock.builder().beginControlFlow("if(sInstance == null)", new Object[0]).addStatement(String.format("sInstance = new %s()", this.clazz.name), new Object[0]).endControlFlow().addStatement("return sInstance", new Object[0]).build();
        MethodSpec getInstanceMethod = MethodSpec.methodBuilder((String)"getInstance").returns((TypeName)ClassName.bestGuess((String)this.clazz.name)).addCode(codeBlock).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        this.clazzBuilder.addMethod(getInstanceMethod);
    }

    private void createInstanceField() {
        FieldSpec sInstanceField = FieldSpec.builder((TypeName)this.classObjectType, (String)S_INSTANCE, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
        this.clazzBuilder.addField(sInstanceField);
    }

    private boolean isEmptyConstructorCreated() {
        TypeSpec typeSpec = this.clazzBuilder.build();
        for (MethodSpec methodSpec : typeSpec.methodSpecs) {
            if (!"<init>".equalsIgnoreCase(methodSpec.name) || !methodSpec.parameters.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

