/*
 * Decompiled with CFR 0.152.
 */
package dev.cookiecode.rika2mqtt.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import com.google.gson.Gson;
import dev.cookiecode.rika2mqtt.bridge.misc.EmailObfuscator;
import dev.cookiecode.rika2mqtt.rika.firenet.RikaFirenetService;
import dev.cookiecode.rika2mqtt.rika.firenet.exception.CouldNotAuthenticateToRikaFirenetException;
import dev.cookiecode.rika2mqtt.rika.firenet.exception.InvalidStoveIdException;
import dev.cookiecode.rika2mqtt.rika.firenet.exception.OutdatedRevisionException;
import dev.cookiecode.rika2mqtt.rika.firenet.exception.UnableToControlRikaFirenetException;
import dev.cookiecode.rika2mqtt.rika.firenet.exception.UnableToRetrieveRikaFirenetDataException;
import dev.cookiecode.rika2mqtt.rika.firenet.model.StoveId;
import dev.cookiecode.rika2mqtt.rika.firenet.model.StoveStatus;
import dev.cookiecode.rika2mqtt.rika.mqtt.MqttService;
import dev.cookiecode.rika2mqtt.rika.mqtt.event.MqttCommandEvent;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class Bridge {
    @Generated
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    static final String INITIALIZING_BRIDGE = "Initializing Rika2Mqtt bridge :";
    static final String RECEIVED_MQTT_COMMAND_FOR_STOVE_S = "Received mqtt command for stove: %s";
    static final String COULD_NOT_PROCESS_THE_RECEIVED_MQTT_COMMAND_S = "Could not process the received mqtt command: %s";
    static final String COULD_NOT_RETRIEVE_ANY_STOVE_LINKED_WITH_ACCOUNT_S_PLEASE_DOUBLE_CHECK_YOUR_CONFIGURATION = "Could not retrieve any stove linked with account %s. Please double-check your configuration.";
    static final String WILL_NOW_RETRIEVE_STATUS_FOR_EACH_DECLARED_STOVES_AT_INTERVAL_OF_S_AND_PUBLISH_IT_BACK_TO_MQTT = "Will now retrieve status for each declared stove(s) at interval of %s and publish it back to mqtt.";
    private final RikaFirenetService rikaFirenetService;
    private final MqttService mqttService;
    @Value(value="${rika.email}")
    private String rikaEmailAccount;
    @Value(value="${bridge.reportInterval}")
    private Duration bridgeReportInterval;
    private final EmailObfuscator emailObfuscator;
    private final Gson gson;
    private final List<StoveId> stoveIds = new ArrayList();

    @PostConstruct
    void init() {
        ((FluentLogger.Api)log.atInfo()).log(INITIALIZING_BRIDGE);
        this.initStoves(this.rikaFirenetService.getStoves());
        this.printStartupMessages();
        this.publishToMqtt();
    }

    @VisibleForTesting
    void initStoves(List<StoveId> stoveIds) {
        this.stoveIds.clear();
        this.stoveIds.addAll(stoveIds);
    }

    @VisibleForTesting
    void printStartupMessages() {
        String maskedEmailAccount = this.emailObfuscator.maskEmailAddress(this.rikaEmailAccount);
        if (this.stoveIds.isEmpty()) {
            ((FluentLogger.Api)log.atSevere()).log(COULD_NOT_RETRIEVE_ANY_STOVE_LINKED_WITH_ACCOUNT_S_PLEASE_DOUBLE_CHECK_YOUR_CONFIGURATION, (Object)maskedEmailAccount);
        } else {
            ((FluentLogger.Api)log.atInfo()).log("Found %s stoves linked with account %s.", this.stoveIds.size(), (Object)maskedEmailAccount);
            ((FluentLogger.Api)log.atInfo()).log(WILL_NOW_RETRIEVE_STATUS_FOR_EACH_DECLARED_STOVES_AT_INTERVAL_OF_S_AND_PUBLISH_IT_BACK_TO_MQTT, (Object)this.bridgeReportInterval);
        }
    }

    @Scheduled(fixedDelayString="${bridge.reportInterval}")
    void publishToMqtt() {
        this.stoveIds.forEach(stoveId -> {
            try {
                StoveStatus status = this.rikaFirenetService.getStatus(stoveId);
                this.mqttService.publish(this.gson.toJson((Object)status));
            }
            catch (InvalidStoveIdException e) {
                this.stoveIds.remove(stoveId);
                ((FluentLogger.Api)log.atSevere()).log(e.getMessage(), (Object)e);
            }
            catch (CouldNotAuthenticateToRikaFirenetException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause((Throwable)e)).log(e.getMessage());
            }
            catch (UnableToRetrieveRikaFirenetDataException e) {
                ((FluentLogger.Api)log.atSevere()).log(e.getMessage(), (Object)e);
            }
        });
    }

    @EventListener(value={MqttCommandEvent.class})
    public void onReceiveMqttCommand(@NonNull MqttCommandEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        try {
            ((FluentLogger.Api)log.atInfo()).log(RECEIVED_MQTT_COMMAND_FOR_STOVE_S, (Object)event.getStoveId().toString());
            this.rikaFirenetService.updateControls(StoveId.of((Long)event.getStoveId()), event.getProps());
        }
        catch (InvalidStoveIdException | UnableToControlRikaFirenetException ex) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(ex)).log(COULD_NOT_PROCESS_THE_RECEIVED_MQTT_COMMAND_S, (Object)ex.getMessage());
        }
        catch (OutdatedRevisionException ex) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atWarning()).withCause((Throwable)ex)).log(COULD_NOT_PROCESS_THE_RECEIVED_MQTT_COMMAND_S, (Object)ex.getMessage());
        }
    }

    @Generated
    public Bridge(RikaFirenetService rikaFirenetService, MqttService mqttService, EmailObfuscator emailObfuscator, Gson gson) {
        this.rikaFirenetService = rikaFirenetService;
        this.mqttService = mqttService;
        this.emailObfuscator = emailObfuscator;
        this.gson = gson;
    }
}

