/*
 * Decompiled with CFR 0.152.
 */
package libretto.testing;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import libretto.CoreLib;
import libretto.ScalaDSL;
import libretto.ScalaRunner;
import libretto.StarterKit$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class TestSuite
extends AnyFunSuite
implements BeforeAndAfterAll,
AnyFunSuiteLike {
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private final StarterKit$ kit;
    private ScheduledExecutorService scheduler;
    private ExecutorService blockingExecutor;
    private ScalaRunner<ScalaDSL, Future> runner;

    public TestSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.kit = StarterKit$.MODULE$;
        Statics.releaseFence();
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$0) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$0;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public StarterKit$ kit() {
        return this.kit;
    }

    public void beforeAll() {
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.blockingExecutor = Executors.newCachedThreadPool();
        this.runner = StarterKit$.MODULE$.runner((Executor)this.blockingExecutor, this.scheduler);
    }

    public void afterAll() {
        this.blockingExecutor.shutdown();
        this.scheduler.shutdown();
    }

    public void assertCompletes(Object prg) {
        Await$.MODULE$.result((Awaitable)this.runner.run(prg), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    public void assertCocompletes(Object prg) {
        this.assertCompletes(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().dsl().introSnd(this.kit().coreLib().LinearFunctionOps(this.kit().dsl().lInvertSignal()).$greater().apply(this.kit().dsl().fst(prg)))).$greater().apply(this.kit().dsl().assocRL())).$greater().apply(this.kit().dsl().elimFst(this.kit().dsl().rInvertSignal())));
    }

    public <A> void assertVal(Object prg, A expected) {
        A a;
        Object object = Await$.MODULE$.result((Awaitable)this.runner.runScala(prg), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        boolean bl = BoxesRunTime.equals((Object)object, a = expected);
        Bool bool$proxy1 = Bool$.MODULE$.binaryMacroBool(object, "==", a, bl, Prettifier$.MODULE$.default());
        String clue$proxy1 = "";
        Position pos$proxy2 = Position$.MODULE$.apply("TestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42);
        Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy1, (Object)clue$proxy1, pos$proxy2);
    }

    public <A> void testVal(Object prg, Function1<A, BoxedUnit> f) {
        f.apply(Await$.MODULE$.result((Awaitable)this.runner.runScala(prg), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void assertCrashes(Object prg, Option<String> expectedMsg) {
        Try try_ = (Try)((Future)Await$.MODULE$.ready((Awaitable)this.runner.run(prg), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds())).value().get();
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Success)try_).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                Bool bool$proxy2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                String clue$proxy2 = "Expected crash, but the program completed successfully.";
                Position pos$proxy4 = Position$.MODULE$.apply("TestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50);
                Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy2, (Object)clue$proxy2, pos$proxy4);
                return;
            }
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Throwable e = ((Failure)try_).exception();
        expectedMsg.foreach((Function1 & Serializable)msg -> {
            String clue$proxy3 = new StringBuilder(37).append("Expected message ").append((String)msg).append(", actual exception: ").append(e).toString();
            String string = e.getMessage();
            String string2 = msg;
            String string3 = string;
            String string4 = string2;
            boolean bl = !(string3 != null ? !string3.equals(string4) : string4 != null);
            Bool bool$proxy3 = Bool$.MODULE$.binaryMacroBool((Object)string, "==", (Object)string2, bl, Prettifier$.MODULE$.default());
            Position pos$proxy6 = Position$.MODULE$.apply("TestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53);
            return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy3, (Object)clue$proxy3, pos$proxy6);
        });
    }

    public Option<String> assertCrashes$default$2() {
        return None$.MODULE$;
    }

    public void assertCrashes(Object prg, String expectedMsg) {
        this.assertCrashes(prg, (Option<String>)Some$.MODULE$.apply((Object)expectedMsg));
    }

    public <A, B> Object assertLeft() {
        return this.kit().dsl().either(this.kit().dsl().id(), this.kit().dsl().crashNow("Expected left, was right"));
    }

    public <A, B> Object assertRight() {
        return this.kit().dsl().either(this.kit().dsl().crashNow("Expected right, was left"), this.kit().dsl().id());
    }

    public <A, B> Object expectPoll(Object f, CoreLib.Junction.Positive<B> evidence$1) {
        return this.kit().coreLib().LinearFunctionOps(f).$greater().apply(this.kit().coreStreams().LPollable().from(this.kit().coreLib().LinearFunctionOps(this.kit().coreStreams().LPollable().close()).$greater().apply(this.kit().dsl().crashd("Expected poll, received close")), this.kit().coreStreams().LPollable().poll()));
    }

    public <A, B> Object timeout(Object f, FiniteDuration d, CoreLib.Junction.Positive<B> evidence$2) {
        String msg = new StringBuilder(33).append("No action (poll or close) within ").append(d).toString();
        return this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().FocusedOnPairCo(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(this.kit().coreLib().LinearFunctionOps(f).from($less$colon$less$.MODULE$.refl())).to($less$colon$less$.MODULE$.refl())).choice(this.kit().dsl().crashNow(msg), this.kit().dsl().id())).to($less$colon$less$.MODULE$.refl())).$greater().apply(this.kit().coreLib().selectAgainstL(this.kit().coreStreams().LPollable().negativeLPollable(evidence$2)))).to($less$colon$less$.MODULE$.refl())).$greater()).fst().apply(this.kit().dsl().delayNeed(d))).to($less$colon$less$.MODULE$.refl())).elimFst(this.kit().dsl().need(), $less$colon$less$.MODULE$.refl())).to($less$colon$less$.MODULE$.refl());
    }
}

