/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se.infra;

import dev.comfast.cf.CfApi;
import dev.comfast.cf.common.errors.CfFrameworkError;
import dev.comfast.cf.se.infra.DriverSessionCache;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverSource {
    private static final Logger log = LoggerFactory.getLogger(DriverSource.class);
    private static final ThreadLocal<RemoteWebDriver> instances = ThreadLocal.withInitial(() -> new DriverSessionCache(DriverSource::runDriver).get());

    public static RemoteWebDriver getDriver() {
        return instances.get();
    }

    private static RemoteWebDriver runDriver() {
        String name = CfApi.config.getString("cf.browser.name");
        RemoteWebDriver driver = DriverSource.doRunDriver(name);
        if (CfApi.config.getBool("cf.browser.autoClose")) {
            log.info("Auto closing driver {}", (Object)driver.getSessionId());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((RemoteWebDriver)driver).quit()));
        }
        return driver;
    }

    private static RemoteWebDriver doRunDriver(String name) {
        switch (name) {
            case "brave": {
                ChromeOptions opts = new ChromeOptions();
                opts.setBinary("C:\\Program Files\\BraveSoftware\\Brave-Browser\\Application\\brave.exe");
                opts.addArguments(new String[]{"--remote-allow-origins=*"});
                return new ChromeDriver(opts);
            }
            case "chrome": {
                return new ChromeDriver();
            }
            case "firefox": {
                return new FirefoxDriver();
            }
            case "edge": {
                return new EdgeDriver();
            }
        }
        throw new CfFrameworkError("invalid browser name: " + name, new Object[0]);
    }

    private DriverSource() {
    }
}

