/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se;

import dev.comfast.cf.CfAbstractLocator;
import dev.comfast.cf.CfApi;
import dev.comfast.cf.CfFoundLocator;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.conditions.Condition;
import dev.comfast.cf.common.selector.SelectorChain;
import dev.comfast.cf.se.Finder;
import dev.comfast.cf.se.FoundElement;
import dev.comfast.cf.se.WebElementFinder;
import dev.comfast.cf.se.infra.DriverSource;
import dev.comfast.util.Utils;
import dev.comfast.util.waiter.Waiter;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class SeleniumLocator
extends CfAbstractLocator
implements CfLocator {
    private final Finder<WebElement> finder;

    public SeleniumLocator(String selector, Object ... params) {
        this(new SelectorChain(String.format(selector, params)));
    }

    protected SeleniumLocator(SelectorChain chain) {
        super(chain);
        this.finder = new WebElementFinder(chain);
    }

    @Override
    public CfLocator $(String selector, Object ... params) {
        return new SeleniumLocator(this.chain.add(String.format(selector, params)));
    }

    @Override
    public CfFoundLocator find() {
        return new FoundElement(this.chain, this.doFind());
    }

    @Override
    public Optional<CfFoundLocator> tryFind() {
        try {
            return Optional.of(this.find());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public String getAttribute(String name) {
        return this.action(() -> this.doFind().getAttribute(name), "getAttribute", name);
    }

    @Override
    public String getCssValue(String name) {
        return this.action(() -> this.doFind().getCssValue(name), "getCssValue", name);
    }

    @Override
    public String getTagName() {
        return this.action(() -> this.doFind().getTagName(), "getTagName", new Object[0]);
    }

    @Override
    public boolean exists() {
        return this.action(() -> this.tryFind().isPresent(), "isDisplayed", new Object[0]);
    }

    @Override
    public boolean isDisplayed() {
        return this.action(() -> this.doTryFind().map(WebElement::isDisplayed).orElse(false), "isDisplayed", new Object[0]);
    }

    @Override
    public void tap() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void click() {
        this.action(() -> this.doFind().click(), "click", new Object[0]);
    }

    @Override
    public void focus() {
        this.action(() -> this.doExecuteJs("el.focus()", new Object[0]), "focus", new Object[0]);
    }

    @Override
    public void hover() {
        this.action(() -> new Actions((WebDriver)DriverSource.getDriver()).moveToElement(this.doFind()).perform(), "hover", new Object[0]);
    }

    @Override
    public void dragTo(CfLocator target) {
        this.action(() -> {
            WebElement targetEl = ((SeleniumLocator)target).doFind();
            this.doExecuteJs(Utils.readResourceFile((String)"js/dragAndDrop.js") + "executeDragAndDrop(el, arguments[0])", targetEl);
        }, "dragTo", target);
    }

    @Override
    public void setValue(String value) {
        this.action(() -> this.doExecuteJs("el.value = arguments[0]", value), "setValue:", value);
    }

    @Override
    public void setChecked(boolean state) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void clear() {
        this.action(() -> this.doFind().clear(), "clear", new Object[0]);
    }

    @Override
    public void type(String keys) {
        this.action(() -> this.doFind().sendKeys(new CharSequence[]{keys}), "type:", keys);
    }

    @Override
    public int count() {
        return this.action(() -> this.finder.findAll().size(), "count", new Object[0]);
    }

    @Override
    public CfFoundLocator nth(int nth) {
        return this.action(() -> new FoundElement(this.chain, this.finder.findAll().get(nth - 1)), "nth(%d)", nth);
    }

    @Override
    public void waitFor(Function<CfLocator, Object> func, long timeoutMs) {
        this.action(timeoutMs, (Runnable)((Object)func), "wait for function", new Object[0]);
    }

    @Override
    public void should(Condition condition) {
        Waiter waiter = CfApi.getWaiter().configure(c -> c.timeoutMs(CfApi.config.getLong("cf.timeoutMs")).description("should " + condition));
        this.action(() -> condition.expect(this), "should " + condition, new Object[0]);
    }

    @Override
    public Object executeJs(String script, Object ... args) {
        return this.action(() -> this.doExecuteJs(script, args), "ececuteJs", script, args);
    }

    @Override
    public <T> List<T> map(Function<CfFoundLocator, T> func) {
        return this.action(() -> this.finder.findAll().stream().map((? super T el) -> new FoundElement(this.chain, (WebElement)el)).map(func).collect(Collectors.toList()), "map", new Object[0]);
    }

    @Override
    public void forEach(Consumer<CfFoundLocator> func) {
        this.action(() -> this.finder.findAll().stream().map((? super T el) -> new FoundElement(this.chain, (WebElement)el)).forEach(func), "forEach", new Object[0]);
    }

    protected Object doExecuteJs(String script, Object ... args) {
        Object[] argsWithWebElement = this.addArgument(args, this.doFind());
        return DriverSource.getDriver().executeScript("const el = arguments[" + args.length + "];\n" + script, argsWithWebElement);
    }

    protected WebElement doFind() {
        return this.finder.find();
    }

    protected Optional<WebElement> doTryFind() {
        try {
            return Optional.of(this.doFind());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Object[] addArgument(Object[] array, Object addElement) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = addElement;
        return newArray;
    }
}

