/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.utils;

import dev.comfast.experimental.events.EventListener;
import dev.comfast.experimental.events.model.AfterEvent;
import dev.comfast.rgx.RgxApi;
import dev.comfast.util.Utils;
import java.util.Map;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Response;

public class Tracer
implements EventListener<Command> {
    public void after(AfterEvent<Command> event) {
        System.out.print(this.formatLogMessage(event));
    }

    protected String formatLogMessage(AfterEvent<Command> event) {
        return String.format("%-25s | %-40s | %-20s | %s%n", event.actionName, Utils.trimString((Object)this.formatPayload((Command)event.context), (int)40), ((Response)event.result).getState(), event.time);
    }

    private Object formatPayload(Command context) {
        Map params = context.getParameters();
        if (params.containsKey("value")) {
            if (params.containsKey("id")) {
                return this.trimId(params.get("id")) + params.get("value");
            }
            if (params.containsKey("shadowId")) {
                return this.trimId(params.get("shadowId")) + params.get("value");
            }
            return params.get("value");
        }
        if (params.containsKey("name")) {
            return this.trimId(params.get("id")) + params.get("name");
        }
        if (params.containsKey("script")) {
            return params.get("script");
        }
        return "";
    }

    private String trimId(Object seleniumId) {
        String match = RgxApi.rgx((String)"(_element_\\d+)$").match(seleniumId.toString()).getOrElse("");
        return match.isEmpty() ? "" : match + " >> ";
    }
}

