/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.utils;

import dev.comfast.experimental.events.EventListener;
import dev.comfast.experimental.events.model.AfterEvent;
import dev.comfast.util.TerminalGenerator;
import dev.comfast.util.time.TimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.stream.Collectors;

public class EventStats<T>
implements EventListener<T> {
    private final String name;
    private final HashMap<String, LongSummaryStatistics> data = new HashMap();

    public void after(AfterEvent<T> event) {
        this.countTime(event.actionName, event.time.nanos);
        this.countTime("TOTAL", event.time.nanos);
    }

    private void countTime(String key, long nanos) {
        this.data.computeIfAbsent(key, k -> new LongSummaryStatistics()).accept(nanos);
    }

    public String printStats() {
        List stats = this.data.entrySet().stream().sorted(Comparator.comparingLong(a -> ((LongSummaryStatistics)a.getValue()).getSum())).map(entry -> this.formatStats((String)entry.getKey(), (LongSummaryStatistics)entry.getValue())).collect(Collectors.toList());
        if (stats.isEmpty()) {
            return this.name + " - EMPTY STATS";
        }
        return String.format("%s:%n%s%n%s%n%n", this.name, "=".repeat(65), new TerminalGenerator(" | ").table(List.of("actionName", "count", "min", "max", "avg", "total"), stats));
    }

    private List<String> formatStats(String name, LongSummaryStatistics stats) {
        TimeFormatter formatter = new TimeFormatter();
        return List.of(name, String.valueOf(stats.getCount()), formatter.formatNanoseconds(stats.getMin()), formatter.formatNanoseconds(stats.getMax()), formatter.formatNanoseconds(Double.valueOf(stats.getAverage()).longValue()), formatter.formatNanoseconds(stats.getSum()));
    }

    public EventStats(String name) {
        this.name = name;
    }
}

