/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.utils;

import dev.comfast.cf.CfApi;
import dev.comfast.util.TempFile;
import dev.comfast.util.Utils;
import org.intellij.lang.annotations.Language;
import org.openqa.selenium.JavascriptException;

public class BrowserContent {
    public void openResourceFile(String resourcePath) {
        TempFile tempFile = new TempFile("comfast-unit-tests/" + resourcePath);
        tempFile.write(Utils.readResourceFile((String)resourcePath));
        CfApi.open(tempFile.file.toUri().toURL().toString());
    }

    public BrowserContent setStyle(@Language(value="CSS") String styleContent) {
        this.executeJs("document.querySelector('html>head').innerHTML = arguments[0]", "<style>" + styleContent + "</style>");
        return this;
    }

    public BrowserContent setBody(@Language(value="HTML") String bodyHtml) {
        this.executeJs("document.querySelector('html>body').innerHTML = arguments[0]", bodyHtml);
        return this;
    }

    public BrowserContent addJsTools() {
        this.setScriptTag("const $$ = (css, parent = document) => Array.from(parent.querySelectorAll(css));\nconst $ =  (css, parent = document) => parent.querySelector(css);\n");
        return this;
    }

    public BrowserContent setScriptTag(@Language(value="JavaScript") String scriptContent) {
        String escapedScriptContent = scriptContent.replace("`", "\\`");
        String ADD_SCRIPT = "const s = document.createElement('script');s.innerHTML = `" + escapedScriptContent + "`; document.querySelector('head').append(s);";
        this.executeJs(ADD_SCRIPT, new Object[0]);
        return this;
    }

    public void clearAll() {
        this.executeJs("document.querySelector('html').innerHTML = ''", new Object[0]);
    }

    private Object executeJs(@Language(value="JavaScript") String script, Object ... args) {
        try {
            return CfApi.executeJs(script, args);
        }
        catch (JavascriptException e) {
            if (e.getMessage().contains("This document requires 'TrustedHTML' assignment")) {
                CfApi.open("about:blank");
                return CfApi.executeJs(script, args);
            }
            throw e;
        }
    }
}

