/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.conditions;

import dev.comfast.cf.CfFoundLocator;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.conditions.AllMatch;
import dev.comfast.cf.common.conditions.Condition;
import dev.comfast.cf.common.conditions.ConditionImpl;
import dev.comfast.cf.common.utils.TextUtils;
import java.util.function.Function;

public class Conditions {
    public static Condition exists = Conditions.condition("exists", el -> true);
    public static Condition appear = Conditions.condition("appear", CfLocator::isDisplayed);
    public static Condition disappear = Conditions.not(appear, "disappear");
    public static Condition beDisabled = Conditions.hasAttribute("disabled", "true");
    public static Condition beEnabled = Conditions.not(beDisabled);
    public static Condition beClickable = Conditions.allMatch(exists, appear, beEnabled);

    public static Condition condition(String name, Function<CfFoundLocator, Boolean> testFunc) {
        return ConditionImpl.builder().name(name).testFunc(testFunc).build();
    }

    public static Condition not(Condition condition) {
        return condition.negate();
    }

    public static Condition not(Condition condition, String newName) {
        return condition.negate(newName);
    }

    public static Condition allMatch(Condition ... conditions) {
        return new AllMatch(conditions);
    }

    public static Condition hasAttribute(String name) {
        return Conditions.condition(String.format("has attribute: '%s'", name), el -> el.getAttribute(name) != null);
    }

    public static Condition hasAttribute(String name, String expectedValue) {
        return Conditions.condition(String.format("has attribute %s='%s'", name, expectedValue), el -> el.getAttribute(name).equals(expectedValue));
    }

    public static Condition hasText(String expectedText) {
        return Conditions.condition(String.format("has text: '%s'", expectedText), el -> TextUtils.flatText(el.getText()).equals(TextUtils.flatText(expectedText)));
    }

    public static Condition containText(String expectedText) {
        return Conditions.condition(String.format("contain text: '%s'", expectedText), el -> TextUtils.flatText(el.getAttribute("textContent")).contains(TextUtils.flatText(expectedText)));
    }

    public static Condition hasCssClass(String expectedClass) {
        return Conditions.condition(String.format("has class: '%s'", expectedClass), el -> el.hasClass(expectedClass));
    }

    public static Condition haveCount(int expectedCount) {
        return Conditions.condition(String.format("have %d elements", expectedCount), el -> el.count() == expectedCount);
    }
}

