/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.conditions;

import dev.comfast.cf.CfFoundLocator;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.conditions.Condition;
import dev.comfast.cf.common.errors.ConditionFailed;
import dev.comfast.cf.common.errors.ElementFindFail;
import java.util.function.Function;

public class ConditionImpl
implements Condition {
    final String name;
    private final boolean passIfNotFound;
    private final boolean negated;
    private final Function<CfFoundLocator, Boolean> testFunc;

    public boolean test(CfLocator el) {
        try {
            return this.testFunc.apply(el.find());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void expect(CfLocator locator) {
        try {
            CfFoundLocator foundEl = locator.find();
            boolean result = this.negated ^ this.testFunc.apply(foundEl);
            if (!result) {
                throw new ConditionFailed("Condition: \"%s\" failed for element: %s", this.name, foundEl);
            }
        }
        catch (ElementFindFail e) {
            if (this.negated ^ this.passIfNotFound) {
                return;
            }
            throw new ConditionFailed("Condition: \"%s\" failed. Element not found:%n%s", (Throwable)e, this.name, e.getPointer());
        }
        catch (ConditionFailed e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConditionFailed("Condition: \"%s\" failed with exception. %nElement: %s", (Throwable)e, this.name);
        }
    }

    @Override
    public ConditionImpl negate(String newName) {
        return this.toBuilder().name(newName).negated(!this.negated).build();
    }

    public String toString() {
        return this.name;
    }

    ConditionImpl(String name, boolean passIfNotFound, boolean negated, Function<CfFoundLocator, Boolean> testFunc) {
        this.name = name;
        this.passIfNotFound = passIfNotFound;
        this.negated = negated;
        this.testFunc = testFunc;
    }

    public static ConditionImplBuilder builder() {
        return new ConditionImplBuilder();
    }

    public ConditionImplBuilder toBuilder() {
        return new ConditionImplBuilder().name(this.name).passIfNotFound(this.passIfNotFound).negated(this.negated).testFunc(this.testFunc);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPassIfNotFound() {
        return this.passIfNotFound;
    }

    public static class ConditionImplBuilder {
        private String name;
        private boolean passIfNotFound;
        private boolean negated;
        private Function<CfFoundLocator, Boolean> testFunc;

        ConditionImplBuilder() {
        }

        public ConditionImplBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConditionImplBuilder passIfNotFound(boolean passIfNotFound) {
            this.passIfNotFound = passIfNotFound;
            return this;
        }

        public ConditionImplBuilder negated(boolean negated) {
            this.negated = negated;
            return this;
        }

        public ConditionImplBuilder testFunc(Function<CfFoundLocator, Boolean> testFunc) {
            this.testFunc = testFunc;
            return this;
        }

        public ConditionImpl build() {
            return new ConditionImpl(this.name, this.passIfNotFound, this.negated, this.testFunc);
        }

        public String toString() {
            return "ConditionImpl.ConditionImplBuilder(name=" + this.name + ", passIfNotFound=" + this.passIfNotFound + ", negated=" + this.negated + ", testFunc=" + this.testFunc + ")";
        }
    }
}

