/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.conditions;

import dev.comfast.cf.CfFoundLocator;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.conditions.Condition;
import dev.comfast.cf.common.errors.ConditionFailed;
import dev.comfast.cf.common.errors.ElementFindFail;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AllMatch
implements Condition {
    private final String name;
    private final Condition[] subConditions;
    private final boolean passIfNotFound;

    public AllMatch(Condition ... conditions) {
        this.name = String.format("match all [%s]", Arrays.stream(conditions).map(Condition::getName).collect(Collectors.joining(", ")));
        this.subConditions = conditions;
        this.passIfNotFound = Stream.of(conditions).allMatch(Condition::isPassIfNotFound);
    }

    @Override
    public void expect(CfLocator locator) {
        CfFoundLocator foundElement;
        try {
            foundElement = locator.find();
        }
        catch (ElementFindFail e) {
            if (this.passIfNotFound) {
                return;
            }
            throw new ConditionFailed("Condition '%s' failed. Element not found: %s", this.name, e.getPointer());
        }
        StringBuilder resultMessage = new StringBuilder("Should match all: ");
        for (Condition condition : this.subConditions) {
            try {
                condition.expect(foundElement);
                resultMessage.append("\nPASSED: ").append(condition);
            }
            catch (Exception e) {
                resultMessage.append("\nFAILED: ").append(condition);
                throw new ConditionFailed(resultMessage.toString(), new Object[0]);
            }
        }
    }

    @Override
    public Condition negate(String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPassIfNotFound() {
        return this.passIfNotFound;
    }
}

