/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf;

import dev.comfast.cf.CfApi;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.selector.SelectorChain;
import dev.comfast.experimental.events.model.BeforeEvent;
import java.util.Arrays;
import java.util.function.Supplier;

public abstract class CfAbstractLocator
implements CfLocator {
    protected final SelectorChain chain;

    @Override
    public boolean hasClass(String cssClass) {
        return Arrays.asList(this.getAttribute("class").split(" ")).contains(cssClass);
    }

    @Override
    public String getText() {
        return this.getAttribute("innerText");
    }

    @Override
    public String innerHtml() {
        return this.getAttribute("innerHTML");
    }

    @Override
    public String outerHtml() {
        return this.getAttribute("outerHTML");
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    public String toString() {
        return this.chain.toString();
    }

    protected <T> T action(Supplier<T> actionFunction, String name, Object ... params) {
        return (T)CfApi.locatorEvents.action(new BeforeEvent((Object)this, name, params), () -> CfApi.getWaiter().waitFor(actionFunction));
    }

    protected void action(Runnable actionFunction, String name, Object ... params) {
        CfApi.locatorEvents.action(new BeforeEvent((Object)this, name, params), () -> CfApi.getWaiter().waitFor(actionFunction));
    }

    protected void action(long timeoutMs, Runnable actionFunction, String name, Object ... params) {
        CfApi.locatorEvents.action(new BeforeEvent((Object)this, name, params), () -> CfApi.getWaiter().configure(b -> b.timeoutMs(timeoutMs)).waitFor(actionFunction));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CfAbstractLocator)) {
            return false;
        }
        CfAbstractLocator other = (CfAbstractLocator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SelectorChain this$chain = this.chain;
        SelectorChain other$chain = other.chain;
        return !(this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CfAbstractLocator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SelectorChain $chain = this.chain;
        result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
        return result;
    }

    public CfAbstractLocator(SelectorChain chain) {
        this.chain = chain;
    }
}

