/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se.infra;

import dev.comfast.cf.CfApi;
import dev.comfast.experimental.events.model.BeforeEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;

public class FixedSessionExecutor
extends HttpCommandExecutor {
    private final SessionId sessionId;

    public FixedSessionExecutor(URL browserAddress, SessionId sessionId) {
        super(browserAddress);
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Command command) throws IOException {
        BeforeEvent event = new BeforeEvent((Object)command, command.getName(), new Object[]{command.getParameters().values()});
        CfApi.driverEvents.notifyBefore(event);
        try {
            Response response = command.getName().equals("newSession") ? this.mockNewSession() : super.execute(command);
            return response;
        }
        finally {
            CfApi.driverEvents.notifyAfter(event.passed((Object)"OK"));
        }
    }

    private Response mockNewSession() {
        Response response = new Response(this.sessionId);
        response.setStatus(Integer.valueOf(0));
        response.setValue(Map.of());
        this.setPrivateParentClassField("commandCodec", new W3CHttpCommandCodec());
        this.setPrivateParentClassField("responseCodec", new W3CHttpResponseCodec());
        return response;
    }

    private void setPrivateParentClassField(String fieldName, Object fieldValue) {
        Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set((Object)this, fieldValue);
    }
}

