/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se.infra;

import dev.comfast.cf.se.infra.FixedSessionExecutor;
import dev.comfast.util.TempFile;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverSessionCache {
    private static final Logger log = LoggerFactory.getLogger(DriverSessionCache.class);
    private final TempFile sessionStoreFile = new TempFile("sessionStoreInfo.txt");
    private final Supplier<RemoteWebDriver> newDriverSupplier;

    public RemoteWebDriver get() {
        return this.tryToReconnect().orElseGet(() -> {
            log.info("Reconnect failed, creating new WebDriver instance");
            RemoteWebDriver driver = this.newDriverSupplier.get();
            this.sessionStoreFile.write(String.format("%s\n%s", driver.getSessionId(), ((HttpCommandExecutor)driver.getCommandExecutor()).getAddressOfRemoteServer()));
            return driver;
        });
    }

    private Optional<RemoteWebDriver> tryToReconnect() {
        try {
            log.info("Reconnecting...");
            String[] sessionInfo = this.sessionStoreFile.read().split("\n");
            RemoteWebDriver driver = this.fixedSessionDriver(sessionInfo[0], new URL(sessionInfo[1]));
            this.validateDriverWorks(driver);
            return Optional.of(driver);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    private void validateDriverWorks(RemoteWebDriver driver) {
        driver.getTitle();
        driver.getTitle();
    }

    private RemoteWebDriver fixedSessionDriver(String sessionId, URL browserAddress) {
        FixedSessionExecutor executor = new FixedSessionExecutor(browserAddress, new SessionId(sessionId));
        return new RemoteWebDriver((CommandExecutor)executor, (Capabilities)new DesiredCapabilities());
    }

    public DriverSessionCache(Supplier<RemoteWebDriver> newDriverSupplier) {
        this.newDriverSupplier = newDriverSupplier;
    }
}

