/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se;

import dev.comfast.cf.CfAbstractLocator;
import dev.comfast.cf.CfLocator;
import dev.comfast.cf.common.selector.SelectorChain;
import dev.comfast.cf.se.Finder;
import dev.comfast.cf.se.FoundElement;
import dev.comfast.cf.se.WebElementFinder;
import dev.comfast.cf.se.infra.DriverSource;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class SeleniumLocator
extends CfAbstractLocator
implements CfLocator {
    private final Finder<WebElement> finder;

    public SeleniumLocator(String selector, Object ... params) {
        this(new SelectorChain(String.format(selector, params)));
    }

    protected SeleniumLocator(SelectorChain chain) {
        super(chain);
        this.finder = new WebElementFinder(chain);
    }

    @Override
    public CfLocator $(String selector, Object ... params) {
        return new SeleniumLocator(this.chain.add(String.format(selector, params)));
    }

    @Override
    public String getAttribute(String name) {
        return this.action(() -> this.find().getAttribute(name), "getAttribute", name);
    }

    @Override
    public String getCssValue(String name) {
        return this.action(() -> this.find().getCssValue(name), "getCssValue", name);
    }

    @Override
    public String getTagName() {
        return this.action(() -> this.find().getTagName(), "getTagName", new Object[0]);
    }

    @Override
    public boolean exists() {
        return this.action(() -> this.tryFind().isPresent(), "isDisplayed", new Object[0]);
    }

    @Override
    public boolean isDisplayed() {
        return this.action(() -> this.tryFind().map(WebElement::isDisplayed).orElse(false), "isDisplayed", new Object[0]);
    }

    @Override
    public void tap() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void click() {
        this.action(() -> this.find().click(), "click", new Object[0]);
    }

    @Override
    public void focus() {
        this.action(() -> this.doExecuteJs("el.focus()", new Object[0]), "focus", new Object[0]);
    }

    @Override
    public void hover() {
        WebElement target = this.find();
        this.action(() -> new Actions((WebDriver)DriverSource.getDriver()).moveToElement(target).perform(), "hover", new Object[0]);
    }

    @Override
    public void dragTo(CfLocator target) {
        this.action(() -> {
            WebElement fromEl = this.find();
            WebElement targetEl = ((SeleniumLocator)target).find();
            new Actions((WebDriver)DriverSource.getDriver()).clickAndHold(fromEl).release(targetEl).perform();
        }, "dragTo", target);
    }

    @Override
    public void setValue(String value) {
        this.action(() -> this.doExecuteJs("el.setValue(arguments[0])", value), "setValue:", value);
    }

    @Override
    public void setChecked(boolean state) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void clear() {
        this.action(() -> this.find().clear(), "clear", new Object[0]);
    }

    @Override
    public void type(String keys) {
        this.action(() -> this.find().sendKeys(new CharSequence[]{keys}), "type:", keys);
    }

    @Override
    public int count() {
        return this.action(() -> this.finder.findAll().size(), "count", new Object[0]);
    }

    @Override
    public CfLocator nth(int nth) {
        return this.action(() -> new FoundElement(this.chain, this.finder.findAll().get(nth - 1)), "nth(%d)", nth);
    }

    @Override
    public Object executeJs(String script, Object ... args) {
        return this.action(() -> this.doExecuteJs(script, args), "ececuteJs", script, args);
    }

    @Override
    public <T> List<T> map(Function<CfLocator, T> func) {
        return this.action(() -> this.finder.findAll().stream().map((? super T el) -> new FoundElement(this.chain, (WebElement)el)).map(func).collect(Collectors.toList()), "map", new Object[0]);
    }

    protected Object doExecuteJs(String script, Object ... args) {
        WebElement webElement = this.find();
        Object[] allArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, allArgs, 0, args.length);
        allArgs[args.length] = webElement;
        return DriverSource.getDriver().executeScript("const el = arguments[" + args.length + "];\n" + script, allArgs);
    }

    protected WebElement find() {
        return this.finder.find();
    }

    protected Optional<WebElement> tryFind() {
        try {
            return Optional.of(this.find());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

